/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.Response;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.bridge.spi.servlet.Handler;
import juzu.impl.bridge.spi.servlet.ServletMimeBridge;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Method;
import juzu.io.AppendableStream;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.request.ClientContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletResourceBridge
extends ServletMimeBridge
implements ResourceBridge {
    private Response.Content response;

    ServletResourceBridge(Application application, Handler handler, HttpServletRequest req, HttpServletResponse resp, Method<?> target, Map<String, String[]> parameters) {
        super(application, handler, req, resp, target, parameters);
    }

    @Override
    public ClientContext getClientContext() {
        return this;
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (!(response instanceof Response.Content)) {
            throw new IllegalArgumentException();
        }
        this.response = (Response.Content)response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void send() throws IOException {
        if (this.response != null) {
            String mimeType;
            int status = this.response.getStatus();
            if (status != 200) {
                this.resp.setStatus(status);
            }
            if ((mimeType = this.response.getMimeType()) != null) {
                this.resp.setContentType(mimeType);
            }
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                this.resp.setHeader((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            if (this.response.getKind() == Stream.Char.class) {
                PrintWriter writer = this.resp.getWriter();
                try {
                    this.response.send(new AppendableStream(writer));
                }
                finally {
                    Tools.safeClose(writer);
                }
            }
            ServletOutputStream out = this.resp.getOutputStream();
            try {
                this.response.send(new BinaryOutputStream((OutputStream)out));
            }
            finally {
                Tools.safeClose((Closeable)out);
            }
        }
    }
}

