/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.compiler.Message;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String lineSep = System.getProperty("line.separator");
    private static final ThreadLocal<StringBuilder> currentLog = new ThreadLocal();
    private static final ThreadLocal<DateFormat> format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("h:mm:ss:SSS");
        }
    };
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static final Logger logger = BaseProcessor.getLogger(BaseProcessor.class);
    private boolean formalErrorReporting = false;
    private ProcessingContext context;

    public static Logger getLogger(Class<?> type) {
        String key = type.getName();
        final String name = type.getSimpleName();
        Logger logger = loggers.get(key);
        if (logger == null) {
            logger = new Logger(){

                public void log(CharSequence msg) {
                    BaseProcessor.log(name, msg);
                }

                public void log(CharSequence msg, Throwable t) {
                    BaseProcessor.log(name, msg, t);
                }
            };
            loggers.put(key, logger);
        }
        return logger;
    }

    private static void log(String name, CharSequence msg) {
        String s = format.get().format(new Date());
        StringBuilder sb = currentLog.get();
        if (sb != null) {
            sb.append(s).append(" ").append("[").append(name).append("] ").append(msg).append(lineSep);
        }
    }

    private static void log(String name, CharSequence msg, Throwable t) {
        StringWriter buffer = new StringWriter();
        t.printStackTrace(new PrintWriter(buffer));
        BaseProcessor.log(name, msg);
        StringBuilder sb = currentLog.get();
        if (sb != null) {
            sb.append(buffer);
        }
    }

    protected BaseProcessor() {
    }

    public final boolean getFormalErrorReporting() {
        return this.formalErrorReporting;
    }

    public final ProcessingContext getContext() {
        return this.context;
    }

    @Override
    public final Set<String> getSupportedOptions() {
        Set<String> options = super.getSupportedOptions();
        HashSet<String> our = new HashSet<String>(options);
        our.add("juzu.error_reporting");
        return our;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        currentLog.set(new StringBuilder());
        this.formalErrorReporting = "formal".equalsIgnoreCase(processingEnv.getOptions().get("juzu.error_reporting"));
        this.context = new ProcessingContext(processingEnv);
        this.doInit(this.context);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    protected void doInit(ProcessingContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            try {
                this.doProcess(annotations, roundEnv);
                ** GOTO lbl46
            }
            catch (Exception e) {
                block36: {
                    block42: {
                        block41: {
                            if (!(e instanceof ProcessingException)) break block41;
                            ce = (ProcessingException)e;
                            element = ce.getElement();
                            annotation = ce.getAnnotation();
                            msg = new StringBuilder();
                            for (Message cm : ce) {
                                msg.setLength(0);
                                code = cm.getCode();
                                args = cm.getArguments();
                                if (this.formalErrorReporting) {
                                    msg = msg.append("[").append(code.getKey()).append("](");
                                    for (i = 0; i < args.length; ++i) {
                                        if (i > 0) {
                                            msg.append(',');
                                        }
                                        msg.append(String.valueOf(args[i]));
                                    }
                                    msg.append(")");
                                } else {
                                    new Formatter(msg).format(Locale.getDefault(), code.getMessage(), args).flush();
                                }
                                writer = new StringWriter();
                                if (element == null) {
                                    writer.append("Compilation error: ");
                                } else if (annotation == null) {
                                    writer.append("Compilation error for element ").append(element.toString()).append(": ");
                                } else {
                                    writer.append("Compilation error for element ").append(element.toString()).append(" at annotation ").append(annotation.toString()).append(": ");
                                }
                                writer.append(msg).append("\n");
                                e.printStackTrace(new PrintWriter(writer));
                                BaseProcessor.logger.log(writer.getBuffer());
                                this.context.report(Diagnostic.Kind.ERROR, msg, element, annotation, null);
                            }
                            break block42;
lbl46:
                            // 1 sources

                            var14_3 = null;
                            if (roundEnv.processingOver() == false) return false;
                            t = BaseProcessor.currentLog.get().toString();
                            BaseProcessor.currentLog.set(null);
                            if (t.length() <= 0) return false;
                            s = null;
                            in = null;
                            ** GOTO lbl-1000
                        }
                        msg = e.getMessage() == null ? "Exception : " + e.getClass().getName() : e.getMessage();
                        writer = new StringWriter();
                        writer.append("Compilation error: ");
                        writer.append(msg).append("\n");
                        e.printStackTrace(new PrintWriter(writer));
                        BaseProcessor.logger.log(writer.getBuffer());
                        this.context.report(Diagnostic.Kind.ERROR, msg, null, null, null);
                    }
                    var14_4 = null;
                    if (roundEnv.processingOver() == false) return false;
                    t = BaseProcessor.currentLog.get().toString();
                    BaseProcessor.currentLog.set(null);
                    if (t.length() <= 0) return false;
                    s = null;
                    in = null;
                    try {
                        try {
                            file = this.context.getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log");
                            in = file.openInputStream();
                            s = Tools.read(in, "UTF-8");
                        }
                        catch (Exception ignore) {
                            var20_22 = null;
                            Tools.safeClose(in);
                            break block36;
                        }
                        var20_21 = null;
                    }
                    catch (Throwable var19_30) {
                        var20_23 = null;
                        Tools.safeClose(in);
                        throw var19_30;
                    }
                    Tools.safeClose(in);
                }
                out = null;
                try {
                    try {
                        file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log", new Element[0]);
                        out = file.openOutputStream();
                        if (s != null) {
                            out.write(s.getBytes("UTF-8"));
                        }
                        out.write(t.getBytes("UTF-8"));
                    }
                    catch (Exception ignore) {
                        var22_40 = null;
                        Tools.safeClose(out);
                        return false;
                    }
                    var22_39 = null;
                }
                catch (Throwable var21_46) {
                    var22_41 = null;
                    Tools.safeClose(out);
                    throw var21_46;
                }
                Tools.safeClose(out);
                return false;
            }
        }
        catch (Throwable var13_61) {
            block43: {
                block40: {
                    block39: {
                        var14_5 = null;
                        if (roundEnv.processingOver() == false) throw var13_61;
                        t = BaseProcessor.currentLog.get().toString();
                        BaseProcessor.currentLog.set(null);
                        if (t.length() <= 0) throw var13_61;
                        s = null;
                        in = null;
                        try {}
                        catch (Throwable var19_33) {
                            var20_26 = null;
                            Tools.safeClose(in);
                            throw var19_33;
                        }
                        try {}
                        catch (Exception ignore) {
                            var20_25 = null;
                            Tools.safeClose(in);
                            break block39;
                        }
                        file = this.context.getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log");
                        in = file.openInputStream();
                        s = Tools.read(in, "UTF-8");
                        var20_24 = null;
                        Tools.safeClose(in);
                    }
                    out = null;
                    try {}
                    catch (Throwable var21_47) {
                        var22_44 = null;
                        Tools.safeClose(out);
                        throw var21_47;
                    }
                    try {}
                    catch (Exception ignore) {
                        var22_43 = null;
                        Tools.safeClose(out);
                        throw var13_61;
                    }
                    file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log", new Element[0]);
                    out = file.openOutputStream();
                    if (s != null) {
                        out.write(s.getBytes("UTF-8"));
                    }
                    out.write(t.getBytes("UTF-8"));
                    break block43;
lbl-1000:
                    // 1 sources

                    try {}
                    catch (Throwable var19_27) {
                        var20_20 = null;
                        Tools.safeClose(in);
                        throw var19_27;
                    }
                    try {}
                    catch (Exception ignore) {
                        var20_19 = null;
                        Tools.safeClose(in);
                        break block40;
                    }
                    file = this.context.getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log");
                    in = file.openInputStream();
                    s = Tools.read(in, "UTF-8");
                    var20_18 = null;
                    Tools.safeClose(in);
                }
                out = null;
                try {}
                catch (Throwable var21_45) {
                    var22_38 = null;
                    Tools.safeClose(out);
                    throw var21_45;
                }
                try {}
                catch (Exception ignore) {
                    var22_37 = null;
                    Tools.safeClose(out);
                    return false;
                }
                file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log", new Element[0]);
                out = file.openOutputStream();
                if (s != null) {
                    out.write(s.getBytes("UTF-8"));
                }
                out.write(t.getBytes("UTF-8"));
                var22_36 = null;
                Tools.safeClose(out);
                return false;
            }
            var22_42 = null;
            Tools.safeClose(out);
            throw var13_61;
        }
    }

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws ProcessingException;
}

