/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.url;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarEntry;
import juzu.impl.common.AbstractTrie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends AbstractTrie<String, Node> {
    URL url;

    public Node() {
    }

    private Node(Node parent, String key) {
        super(parent, key);
    }

    @Override
    protected Node create(Node parent, String key) {
        return new Node(parent, key);
    }

    void merge(File file) throws IOException {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                Node childNode = (Node)this.add(child.getName());
                if (child.isDirectory()) {
                    childNode.merge(child);
                    continue;
                }
                childNode.url = child.toURI().toURL();
            }
        }
    }

    void merge(URL base, JarEntry entry) throws IOException {
        if (!entry.isDirectory()) {
            this.merge(base, entry.getName(), 0);
        }
    }

    void merge(URL base, String path, int from) throws IOException {
        int pos = path.indexOf(47, from);
        if (pos == -1) {
            String name = path.substring(from);
            Node childNode = (Node)this.add(name);
            childNode.url = new URL("jar:" + base + "!/" + path);
        } else {
            String name = path.substring(from, pos);
            Node childNode = (Node)this.add(name);
            childNode.merge(base, path, pos + 1);
        }
    }
}

