/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.url;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.url.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLFileSystem
extends ReadFileSystem<Node> {
    private final Node root = new Node();

    public URLFileSystem add(ClassLoader loader) throws IOException, URISyntaxException {
        return this.add(loader, loader.getParent());
    }

    public URLFileSystem add(ClassLoader from, ClassLoader to) throws IOException, URISyntaxException {
        URL url2;
        HashSet<URL> urls = Tools.set(from.getResources(""));
        Enumeration<URL> e = from.getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            url2 = e.nextElement();
            if (!"jar".equals(url2.getProtocol())) continue;
            urls.add(url2);
        }
        if (to != null) {
            e = to.getResources("");
            while (e.hasMoreElements()) {
                urls.remove(e.nextElement());
            }
            e = to.getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                url2 = e.nextElement();
                if (!"jar".equals(url2.getProtocol())) continue;
                urls.remove(url2);
            }
        }
        for (URL url2 : urls) {
            this.add(url2);
        }
        if (Inject.class.getClassLoader() == from) {
            this.add(from.getResource(Inject.class.getName().replace('.', '/') + ".class"));
        }
        return this;
    }

    public URLFileSystem add(URL url) throws IOException, URISyntaxException {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            File file = new File(url.toURI());
            if (file.isDirectory()) {
                this.root.merge(file);
            } else {
                JarFile jar = new JarFile(file, false);
                for (JarEntry jarEntry : Tools.iterable(jar.entries())) {
                    this.root.merge(url, jarEntry);
                }
            }
        } else if ("jar".equals(protocol)) {
            String path = url.getPath();
            int pos = path.lastIndexOf("!/");
            if (pos == -1) {
                throw new MalformedURLException("Malformed URL " + url);
            }
            URL inner = new URL(path.substring(0, pos));
            this.add(inner);
        } else {
            throw new UnsupportedOperationException("Cannot handle url " + url + " yet");
        }
        return this;
    }

    @Override
    public Class<Node> getType() {
        return null;
    }

    @Override
    public String getDescription() {
        return "URLFileSystem[]";
    }

    @Override
    public boolean equals(Node left, Node right) {
        return left == right;
    }

    @Override
    public Node getRoot() throws IOException {
        return this.root;
    }

    @Override
    public Node getChild(Node dir, String name) throws IOException {
        return (Node)dir.get(name);
    }

    @Override
    public long getLastModified(Node path) throws IOException {
        return 1L;
    }

    @Override
    public String getName(Node path) throws IOException {
        return (String)path.getKey();
    }

    @Override
    public Iterator<Node> getChildren(Node dir) throws IOException {
        final Iterator entries = dir.getEntries();
        return new Iterator<Node>(){
            private Node next;

            @Override
            public boolean hasNext() {
                while (this.next == null && entries.hasNext()) {
                    Node next = (Node)entries.next();
                    if (next.url == null) continue;
                    this.next = next;
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Node node = this.next;
                    return node;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public PathType typeOf(Node path) throws IOException {
        return path.url == null ? PathType.DIR : PathType.FILE;
    }

    @Override
    public Timestamped<Content> getContent(Node file) throws IOException {
        if (file.url == null) {
            throw new IOException("Cannot find file " + file.getPath());
        }
        URLConnection conn = file.url.openConnection();
        long lastModified = conn.getLastModified();
        byte[] bytes = Tools.bytes(conn.getInputStream());
        return new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
    }

    @Override
    public File getFile(Node path) {
        return null;
    }

    @Override
    public URL getURL(Node path) throws NullPointerException, IOException {
        return path.url;
    }
}

