/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.ast;

import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import juzu.impl.common.Coordinate;
import juzu.impl.common.Location;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Tools;
import juzu.impl.template.spi.juzu.ast.OffsetCharStream;
import juzu.impl.template.spi.juzu.ast.OffsetReader;
import juzu.impl.template.spi.juzu.ast.OffsetTokenManager;
import juzu.impl.template.spi.juzu.ast.ParseException;
import juzu.impl.template.spi.juzu.ast.SectionType;
import juzu.impl.template.spi.juzu.ast.TemplateParser;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTNode<N extends ASTNode<N>>
implements Serializable {
    private static final Coordinate DUMB = new Coordinate(0, new Location(1, 1));
    private final Location beginPosition;
    protected final List<Block<?>> children;
    private final List<Block<?>> unmodifiableChildren;

    protected ASTNode(Location beginPosition, List<Block<?>> children) {
        if (beginPosition == null) {
            throw new NullPointerException("No null position accepted");
        }
        this.beginPosition = beginPosition;
        this.children = children;
        this.unmodifiableChildren = children != null ? Collections.unmodifiableList(children) : Collections.emptyList();
    }

    public Location getBeginPosition() {
        return this.beginPosition;
    }

    public List<Block<?>> getChildren() {
        return this.unmodifiableChildren;
    }

    public N addChildren(Iterable<Block<?>> children) {
        for (Block<?> child : children) {
            this.addChild(child);
        }
        return (N)this;
    }

    public N addChild(Block<?> child) {
        if (this.children == null) {
            throw new IllegalStateException("Node " + this + " cannot have children");
        }
        if (((Block)child).parent != null) {
            ((Block)child).parent.children.remove(child);
            ((Block)child).parent = null;
        }
        ((Block)child).parent = this;
        this.children.add(child);
        return (N)this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Section
    extends Block<Section> {
        private final SectionType type;
        private final String text;

        public Section(SectionType type, String text) {
            this(DUMB, DUMB, type, text);
        }

        public Section(Coordinate begin, Coordinate end, SectionType type, String text) {
            super(begin, end, null);
            if (type == null) {
                throw new NullPointerException();
            }
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
            this.type = type;
        }

        public SectionType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Section) {
                Section that = (Section)obj;
                return this.type == that.type && this.text.equals(that.text);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this.type) + ",text=" + this.text + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URL
    extends Block<URL> {
        private final String typeName;
        private final String methodName;
        private final Map<String, String> args;
        private MethodInvocation invocation;

        public URL(String typeName, String methodName, Map<String, String> args) {
            this(DUMB, DUMB, typeName, methodName, args);
        }

        public URL(Coordinate begin, Coordinate end, String typeName, String methodName, Map<String, String> args) {
            super(begin, end, null);
            this.typeName = typeName;
            this.methodName = methodName;
            this.args = args;
            this.invocation = null;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public MethodInvocation getInvocation() {
            return this.invocation;
        }

        public void setInvocation(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof URL) {
                URL that = (URL)obj;
                return Tools.safeEquals(this.typeName, that.typeName) && this.methodName.equals(that.methodName) && this.args.equals(that.args);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.methodName + ",args=" + this.args + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tag
    extends Block<Tag> {
        private final String name;
        private final Map<String, String> args;
        private transient TagHandler handler;

        public Tag(String name) {
            this(name, Collections.emptyMap());
        }

        public Tag(String name, Map<String, String> args) {
            this(DUMB, DUMB, name, args);
        }

        public Tag(Coordinate begin, Coordinate end, String name, Map<String, String> args) {
            super(begin, end, new ArrayList());
            this.name = name;
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tag) {
                Tag that = (Tag)obj;
                return this.name.equals(this.name) && this.args.equals(that.args) && this.children.equals(that.children);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.name + ",args=" + this.args + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Block<B extends Block<B>>
    extends ASTNode<B> {
        private final Coordinate begin;
        private final Coordinate end;
        private ASTNode<?> parent;

        protected Block(Coordinate begin, Coordinate end, List<Block<?>> children) {
            super(begin.getPosition(), children);
            this.begin = begin;
            this.end = end;
            this.parent = null;
        }

        public ASTNode<?> getParent() {
            return this.parent;
        }

        public void addAfter(Block sibling) {
            if (sibling.parent != null) {
                sibling.parent.children.remove(sibling);
                sibling.parent = null;
            }
            int index = this.parent.children.indexOf(this);
            this.parent.children.add(index + 1, sibling);
            sibling.parent = this.parent;
        }

        public void remove() throws IllegalStateException {
            if (this.parent == null) {
                throw new IllegalStateException("No parent");
            }
            this.parent.children.remove(this);
            this.parent = null;
        }

        public Coordinate getBegin() {
            return this.begin;
        }

        public Coordinate getEnd() {
            return this.end;
        }

        public int getBeginOffset() {
            return this.begin.getOffset();
        }

        public int getEndOffset() {
            return this.end.getOffset();
        }

        public Location getEndPosition() {
            return this.end.getPosition();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Template
    extends ASTNode<Template> {
        public static Template parse(CharSequence s) throws ParseException {
            TemplateParser parser = new TemplateParser(new OffsetTokenManager(new OffsetCharStream(new OffsetReader(new StringReader(s.toString())))));
            return parser.parse();
        }

        public Template() {
            super(new Location(0, 0), new ArrayList());
        }
    }
}

