/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.dialect.gtmpl;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import juzu.impl.template.spi.TemplateStub;
import juzu.impl.template.spi.juzu.dialect.gtmpl.BaseScript;
import juzu.impl.template.spi.juzu.dialect.gtmpl.Foo;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class GroovyTemplateStub
extends TemplateStub {
    protected final String templateId;
    private Class<?> scriptClass;
    private HashMap<Integer, Foo> locationTable;

    protected GroovyTemplateStub() {
        String name = this.getClass().getName();
        this.templateId = name.substring(0, name.length() - 1);
    }

    public GroovyTemplateStub(String templateId) {
        this.templateId = templateId;
        this.scriptClass = null;
        this.locationTable = null;
    }

    public void doInit(ClassLoader loader) {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(BaseScript.class.getName());
        String script = this.getScript();
        GroovyCodeSource gcs = new GroovyCodeSource((InputStream)new ByteArrayInputStream(script.getBytes()), "myscript", "/groovy/shell");
        GroovyClassLoader gcl = new GroovyClassLoader(loader, config);
        try {
            this.scriptClass = gcl.parseClass(gcs, false);
            Class<?> constants = this.scriptClass.getClassLoader().loadClass("Constants");
            this.locationTable = (HashMap)constants.getField("TABLE").get(null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
    }

    public abstract String getScript();

    public String getClassName() {
        return this.scriptClass != null ? this.scriptClass.getName() : null;
    }

    public void doRender(TemplateRenderContext renderContext) throws TemplateExecutionException, IOException {
        BaseScript script = (BaseScript)InvokerHelper.createScript(this.scriptClass, (Binding)(renderContext.getAttributes() != null ? new Binding(renderContext.getAttributes()) : new Binding()));
        script.init(renderContext);
        try {
            script.run();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw this.buildRuntimeException(e);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw this.buildRuntimeException(e);
        }
    }

    private TemplateExecutionException buildRuntimeException(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        Foo firstItem = null;
        for (int i = 0; i < trace.length; ++i) {
            int templateLineNumber;
            StackTraceElement element = trace[i];
            if (!element.getClassName().equals(this.scriptClass.getName())) continue;
            int lineNumber = element.getLineNumber();
            Foo item = this.locationTable.get(lineNumber);
            if (item != null) {
                templateLineNumber = item.getPosition().getLine();
                if (firstItem == null) {
                    firstItem = item;
                }
            } else {
                templateLineNumber = -1;
            }
            trace[i] = element = new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), templateLineNumber);
        }
        t.setStackTrace(trace);
        if (firstItem != null) {
            return new TemplateExecutionException(this.templateId, firstItem.getPosition(), firstItem.getValue(), t);
        }
        return new TemplateExecutionException(this.templateId, null, null, t);
    }
}

