/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.common.DevClassLoader;
import juzu.impl.common.JSON;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.plugin.module.Module;
import juzu.impl.plugin.module.ModuleLifeCycle;

public class ServletModule
extends Module {
    private static final HashMap<String, ServletModule> modules = new HashMap();
    final AtomicInteger leases;
    final ModuleLifeCycle lifeCycle;
    final ServletContext context;
    final AssetServer server;
    final WarFileSystem resources;
    final Logger log = new Logger(){

        public void log(CharSequence msg) {
            System.out.println(msg);
        }

        public void log(CharSequence msg, Throwable t) {
            System.out.println(msg);
            t.printStackTrace();
        }
    };

    static synchronized ServletModule leaseModule(ServletContext context) throws Exception {
        ServletModule module = modules.get(context.getContextPath());
        if (module == null) {
            module = new ServletModule(context);
            modules.put(context.getContextPath(), module);
        }
        module.leases.incrementAndGet();
        return module;
    }

    private static JSON getConfig(ClassLoader loader) throws Exception {
        URL cfg = loader.getResource("juzu/config.json");
        String s = Tools.read(cfg);
        return (JSON)JSON.parse(s);
    }

    private ServletModule(final ServletContext context) throws Exception {
        super(context.getClassLoader(), ServletModule.getConfig(context.getClassLoader()));
        ModuleLifeCycle lifeCycle;
        String srcPath = context.getInitParameter("juzu.src_path");
        ReadFileSystem sourcePath = srcPath != null ? new DiskFileSystem(new File(srcPath)) : WarFileSystem.create(context, "/WEB-INF/src/");
        int runMode = BridgeConfig.getRunMode((Map<String, String>)new SimpleMap<String, String>(){

            @Override
            protected Iterator<String> keys() {
                return Tools.iterator("juzu.run_mode");
            }

            @Override
            public String get(Object key) {
                return key.equals("juzu.run_mode") ? context.getInitParameter("juzu.run_mode") : null;
            }
        });
        switch (runMode) {
            case 1: {
                lifeCycle = new ModuleLifeCycle.Dynamic<File>(this.log, new DevClassLoader(Thread.currentThread().getContextClassLoader()), sourcePath);
                break;
            }
            default: {
                lifeCycle = new ModuleLifeCycle.Static<String>(this.log, Thread.currentThread().getContextClassLoader(), WarFileSystem.create(context, "/WEB-INF/classes/"));
            }
        }
        AssetServer server = (AssetServer)context.getAttribute("asset.server");
        if (server == null) {
            server = new AssetServer();
            context.setAttribute("asset.server", (Object)server);
        }
        this.context = context;
        this.server = server;
        this.resources = WarFileSystem.create(context, "/WEB-INF/");
        this.lifeCycle = lifeCycle;
        this.leases = new AtomicInteger();
    }

    synchronized void release() {
        if (this.leases.decrementAndGet() == 0) {
            modules.remove(this.context.getContextPath());
        }
    }
}

