/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.Serializable;
import java.util.Arrays;
import juzu.impl.common.Lexers;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Serializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final String[] atoms;
    private final boolean absolute;
    private String canonical;

    public static Path absolute(Name qn, String name, String extension) {
        return Path.create(true, qn, name, extension);
    }

    public static Path create(boolean absolute, Name qn, String rawName, String ext) {
        return new Path(absolute, qn, rawName, ext);
    }

    public static Path parse(String path) throws NullPointerException, IllegalArgumentException {
        boolean absolute = path.length() > 0 && path.charAt(0) == '/';
        String[] atoms = Lexers.parsePath(0, EMPTY_STRING_ARRAY, 0, path, 0);
        return new Path(absolute, atoms);
    }

    private Path(boolean absolute, Name pkg, String rawName, String ext) {
        String[] atoms = new String[pkg.size() + 2];
        for (int i = 0; i < pkg.size(); ++i) {
            atoms[i] = pkg.get(i);
        }
        atoms[atoms.length - 2] = rawName;
        atoms[atoms.length - 1] = ext;
        this.absolute = absolute;
        this.canonical = null;
        this.atoms = atoms;
    }

    private Path(boolean absolute, String[] atoms) {
        this.absolute = absolute;
        this.canonical = null;
        this.atoms = atoms;
    }

    public Path append(String path) throws NullPointerException, IllegalArgumentException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            throw new IllegalArgumentException("Cannot append absolute path " + path);
        }
        String[] atoms = Lexers.parsePath(1, this.atoms, this.atoms.length - 2, path, 0);
        return new Path(this.absolute, atoms);
    }

    public String getValue() {
        return this.getCanonical();
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public final boolean isRelative() {
        return !this.isAbsolute();
    }

    public Iterable<String> getDirs() {
        return Tools.iterable(0, this.atoms.length - 2, this.atoms);
    }

    public String getRawName() {
        return this.atoms[this.atoms.length - 2];
    }

    public String getExt() {
        return this.atoms[this.atoms.length - 1];
    }

    public String getName() {
        String ext = this.getExt();
        String rawName = this.getRawName();
        if (ext != null) {
            return rawName + "." + ext;
        }
        return rawName;
    }

    public Path as(String ext) {
        String[] tmp = (String[])this.atoms.clone();
        tmp[tmp.length - 1] = ext;
        return new Path(this.absolute, tmp);
    }

    public String getCanonical() {
        if (this.canonical == null) {
            StringBuilder sb = new StringBuilder();
            if (this.isAbsolute()) {
                sb.append('/');
            }
            for (int i = 0; i < this.atoms.length - 1; ++i) {
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(this.atoms[i]);
            }
            String ext = this.getExt();
            if (ext != null) {
                sb.append('.').append(ext);
            }
            this.canonical = sb.toString();
        }
        return this.canonical;
    }

    public int hashCode() {
        return Arrays.hashCode(this.atoms);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            Path that = (Path)obj;
            return this.absolute == that.absolute && Arrays.equals(this.atoms, that.atoms);
        }
        return false;
    }

    public String toString() {
        return "Path[" + this.getCanonical() + "]";
    }
}

