/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileManager;
import javax.tools.SimpleJavaFileObject;
import juzu.impl.common.Content;
import juzu.impl.common.FileKey;
import juzu.impl.common.Timestamped;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileObjectImpl<P>
extends SimpleJavaFileObject {
    final FileKey key;
    final ReadFileSystem<P> fs;
    private final P file;
    Timestamped<Content> content;
    private boolean writing;

    private static URI toURI(JavaFileManager.Location location, FileKey key) throws IOException {
        try {
            String path = key.packageFQN.length() == 0 ? "/" + key.name : "/" + key.packageFQN.replace('.', '/') + '/' + key.name;
            return new URI("/" + location.getName() + path);
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not build location related URI for " + key);
        }
    }

    public JavaFileObjectImpl(JavaFileManager.Location location, FileKey key, ReadFileSystem<P> fs, P file) throws NullPointerException, IOException {
        super(JavaFileObjectImpl.toURI(location, key), key.getKind());
        if (file == null) {
            throw new NullPointerException("No null file accepted for " + key);
        }
        this.key = key;
        this.fs = fs;
        this.file = file;
        this.writing = false;
    }

    public FileKey getKey() {
        return this.key;
    }

    private Timestamped<Content> assertContent() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.content == null) {
            this.content = this.fs.getContent(this.file);
            if (this.content == null) {
                throw new FileNotFoundException("File " + this.key + " cannot be found");
            }
        }
        return this.content;
    }

    public File getFile() throws IOException {
        return this.fs.getFile(this.file);
    }

    @Override
    public String getName() {
        File f = this.fs.getFile(this.file);
        if (f != null) {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.key.rawName;
    }

    @Override
    public String toString() {
        return this.key.rawName;
    }

    @Override
    public long getLastModified() {
        try {
            return this.assertContent().getTime();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public final CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.assertContent().getObject().getCharSequence();
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        return this.assertContent().getObject().getInputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.fs instanceof ReadWriteFileSystem) {
            final ReadWriteFileSystem fs = (ReadWriteFileSystem)this.fs;
            return new ByteArrayOutputStream(){

                public void close() throws IOException {
                    Content content = new Content(this.toByteArray(), null);
                    long lastModified = fs.setContent(JavaFileObjectImpl.this.file, content);
                    JavaFileObjectImpl.this.content = new Timestamped<Content>(lastModified, content);
                    JavaFileObjectImpl.this.writing = false;
                }
            };
        }
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public Writer openWriter() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.fs instanceof ReadWriteFileSystem) {
            final ReadWriteFileSystem fs = (ReadWriteFileSystem)this.fs;
            return new StringWriter(){

                public void close() throws IOException {
                    Content content = new Content(this.getBuffer());
                    long lastModified = fs.setContent(JavaFileObjectImpl.this.file, content);
                    JavaFileObjectImpl.this.content = new Timestamped<Content>(lastModified, content);
                    JavaFileObjectImpl.this.writing = false;
                }
            };
        }
        throw new UnsupportedOperationException("Read only");
    }
}

