/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SingletonInstantiationStrategy
implements InstantiationStrategy {
    private final Map<String, Object> singletons;
    private final InstantiationStrategy delegate;

    SingletonInstantiationStrategy(InstantiationStrategy delegate, Map<String, Object> singletons) {
        this.delegate = delegate;
        this.singletons = singletons;
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) throws BeansException {
        Object instance = this.singletons.get(beanName);
        if (instance != null) {
            return instance;
        }
        return this.delegate.instantiate(beanDefinition, beanName, owner);
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor<?> ctor, Object[] args) throws BeansException {
        Object instance = this.singletons.get(beanName);
        if (instance != null) {
            return instance;
        }
        return this.delegate.instantiate(beanDefinition, beanName, owner, ctor, args);
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object[] args) throws BeansException {
        Object instance = this.singletons.get(beanName);
        if (instance != null) {
            return instance;
        }
        return this.delegate.instantiate(beanDefinition, beanName, owner, factoryBean, factoryMethod, args);
    }
}

