/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.FileKey;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.plugin.asset.Assets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private HashMap<ElementHandle.Package, AnnotationState> annotations = new HashMap();
    private static final Name ASSETS = Name.create(Assets.class);
    private static final String[] KINDS = new String[]{"scripts", "stylesheets"};

    public AssetMetaModelPlugin() {
        super("asset");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Assets.class);
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getType().equals(ASSETS) && metaModel.getHandle().equals(key.getElement())) {
            this.annotations.put(metaModel.getHandle(), added);
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (key.getType().equals(ASSETS) && metaModel.getHandle().equals(key.getElement())) {
            this.annotations.remove(metaModel.getHandle());
        }
    }

    private List<JSON> build(List<Map<String, Object>> scripts) {
        List<JSON> foo = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            foo = new ArrayList<JSON>(scripts.size());
            for (Map<String, Object> script : scripts) {
                JSON bar = new JSON();
                for (Map.Entry<String, Object> entry : script.entrySet()) {
                    bar.set(entry.getKey(), entry.getValue());
                }
                foo.add(bar);
            }
        }
        return foo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void prePassivate(ApplicationMetaModel metaModel) {
        AnnotationState annotation = this.annotations.get(metaModel.getHandle());
        if (annotation != null) {
            String location = (String)annotation.get("location");
            boolean classpath = location == null || "CLASSPATH".equals(location);
            for (String kind : KINDS) {
                List scripts = (List)annotation.get(kind);
                ProcessingContext context = metaModel.getProcessingContext();
                if (scripts == null) continue;
                for (AnnotationState script : scripts) {
                    String value;
                    Path path;
                    location = (String)script.get("location");
                    if ((location != null || !classpath) && !"CLASSPATH".equals(location) || !(path = Path.parse(value = (String)script.get("src"))).isRelative()) continue;
                    context.log("Found classpath asset to copy " + value);
                    Name qn = metaModel.getHandle().getPackage().append("assets");
                    FileKey absolute = qn.resolve(path);
                    FileObject src = context.resolveResource(metaModel.getHandle(), absolute);
                    if (src != null) {
                        Object var23_23;
                        URI srcURI = src.toUri();
                        context.log("Found asset " + absolute + " on source path " + srcURI);
                        InputStream in = null;
                        OutputStream out = null;
                        try {
                            try {
                                FileObject dst = context.getResource(StandardLocation.CLASS_OUTPUT, absolute);
                                if (dst == null || dst.getLastModified() < src.getLastModified()) {
                                    in = src.openInputStream();
                                    dst = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute, context.get(metaModel.getHandle()));
                                    context.log("Copying asset from source path " + srcURI + " to class output " + dst.toUri());
                                    out = dst.openOutputStream();
                                    Tools.copy(in, out);
                                } else {
                                    context.log("Found up to date related asset in class output for " + srcURI);
                                }
                            }
                            catch (IOException e) {
                                context.log("Could not copy asset " + path + " ", e);
                                var23_23 = null;
                                Tools.safeClose(in);
                                Tools.safeClose(out);
                                continue;
                            }
                            var23_23 = null;
                        }
                        catch (Throwable throwable) {
                            var23_23 = null;
                            Tools.safeClose(in);
                            Tools.safeClose(out);
                            throw throwable;
                        }
                        Tools.safeClose(in);
                        Tools.safeClose(out);
                        continue;
                    }
                    context.log("Could not find asset " + absolute + " on source path");
                }
            }
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        AnnotationState annotation = this.annotations.get(application.getHandle());
        if (annotation != null) {
            JSON json = new JSON();
            json.set("scripts", this.build((List)annotation.get("scripts")));
            json.set("stylesheets", this.build((List)annotation.get("stylesheets")));
            json.set("package", application.getName().append("assets").toString());
            json.set("location", annotation.get("location"));
            return json;
        }
        return null;
    }
}

