/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import juzu.impl.router.CaptureGroupTransformation;
import juzu.impl.router.CharEscapeTransformation;
import juzu.impl.router.MalformedRouteException;
import juzu.impl.router.NonCaptureGroupTransformation;
import juzu.impl.router.RERef;
import juzu.impl.router.Router;
import juzu.impl.router.ValueResolverFactory;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.RERenderer;
import juzu.impl.router.regex.REVisitor;
import juzu.impl.router.regex.SyntaxException;

public class PathParam {
    final String name;
    final boolean preservePath;
    final String routingRegex;
    final RERef[] matchingRegex;
    final String[] templatePrefixes;
    final String[] templateSuffixes;

    private PathParam(String name, boolean preservePath, String routingRegex, RERef[] matchingRegex, String[] templatePrefixes, String[] templateSuffixes) {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (matchingRegex == null || matchingRegex.length == 0) {
            throw new NullPointerException("No null or empty pattern accepted");
        }
        this.name = name;
        this.preservePath = preservePath;
        this.routingRegex = routingRegex;
        this.matchingRegex = matchingRegex;
        this.templatePrefixes = templatePrefixes;
        this.templateSuffixes = templateSuffixes;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "PathParam[name=" + this.name + ",preservePath=" + this.preservePath + ",pattern=" + Arrays.asList(this.matchingRegex) + "]";
    }

    public static Builder matching(String regex) {
        return new Builder().matching(regex);
    }

    public static Builder matchingAny() {
        return new Builder();
    }

    public static class Builder {
        private String pattern;
        private boolean preservePath = false;
        private boolean captureGroup = false;

        PathParam build(Router router, String name) {
            String[] templateSuffixes;
            String[] templatePrefixes;
            RERef[] renderingRegexes;
            String regex;
            Builder descriptor = this;
            if (descriptor == null) {
                throw new NullPointerException("No null descriptor accepted");
            }
            boolean preservePath = false;
            if (descriptor != null) {
                regex = descriptor.getPattern();
                preservePath = descriptor.preservePath;
            } else {
                regex = null;
            }
            if (regex == null) {
                regex = preservePath ? "[^/]+" : ".+";
            }
            StringBuilder routingRegex = new StringBuilder();
            try {
                REVisitor transformer = descriptor.getCaptureGroup() ? new CaptureGroupTransformation() : new NonCaptureGroupTransformation();
                REParser parser = new REParser(regex);
                RENode.Disjunction routingDisjunction = parser.parseDisjunction();
                if (!preservePath) {
                    CharEscapeTransformation escaper = new CharEscapeTransformation('/', '_');
                    routingDisjunction.accept(escaper);
                }
                routingDisjunction.accept(transformer);
                RERenderer.render(routingDisjunction, routingRegex);
                parser.reset();
                RENode.Disjunction renderingDisjunction = parser.parseDisjunction();
                ValueResolverFactory factory = new ValueResolverFactory();
                renderingDisjunction.accept(transformer);
                List<ValueResolverFactory.Alternative> alt = factory.foo(renderingDisjunction);
                renderingRegexes = new RERef[alt.size()];
                templatePrefixes = new String[alt.size()];
                templateSuffixes = new String[alt.size()];
                for (int i = 0; i < alt.size(); ++i) {
                    ValueResolverFactory.Alternative v = alt.get(i);
                    StringBuilder valueMatcher = v.getValueMatcher();
                    valueMatcher.insert(0, '^');
                    valueMatcher.append("$");
                    renderingRegexes[i] = router.compile(valueMatcher.toString());
                    templatePrefixes[i] = v.getPrefix();
                    templateSuffixes[i] = v.getSuffix();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (MalformedRouteException e) {
                throw new RuntimeException(e);
            }
            return new PathParam(name, preservePath, routingRegex.toString(), renderingRegexes, templatePrefixes, templateSuffixes);
        }

        public Builder matching(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder captureGroup(boolean capture) {
            this.captureGroup = capture;
            return this;
        }

        public Builder preservePath(boolean preservePath) {
            this.preservePath = preservePath;
            return this;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public boolean getCaptureGroup() {
            return this.captureGroup;
        }

        public void setCaptureGroup(boolean captureGroup) {
            this.captureGroup = captureGroup;
        }
    }
}

