/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Completion;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;
import juzu.impl.metamodel.MetaModelState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaModelProcessor
extends BaseProcessor {
    public static final MessageCode ANNOTATION_UNSUPPORTED = new MessageCode("ANNOTATION_UNSUPPORTED", "The annotation of this element cannot be supported");
    private MetaModelState<?, ?> state;
    private int index;
    private final Logger log = BaseProcessor.getLogger(this.getClass());
    private HashSet<String> supportedAnnotations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doInit(ProcessingContext context) {
        block7: {
            this.log.log("Using processing env " + context.getClass().getName());
            if (this.state == null) {
                InputStream in = null;
                try {
                    Object var6_6;
                    try {
                        FileObject file = this.getContext().getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "metamodel.ser");
                        in = file.openInputStream();
                        ObjectInputStream ois = new ObjectInputStream(in);
                        this.state = (MetaModelState)ois.readObject();
                        this.log.log("Loaded model from " + file.toUri());
                    }
                    catch (Exception e) {
                        this.log.log("Created new meta model");
                        MetaModelState metaModel = new MetaModelState(this.getPluginType(), this.createMetaModel());
                        metaModel.init(this.getContext());
                        this.state = metaModel;
                        var6_6 = null;
                        Tools.safeClose(in);
                        break block7;
                    }
                    var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    Tools.safeClose(in);
                    throw throwable;
                }
                Tools.safeClose(in);
            }
        }
        HashSet<String> supportedAnnotations = new HashSet<String>();
        Iterator<Class<Annotation>> i$ = this.state.context.getSupportedAnnotations().iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.supportedAnnotations = supportedAnnotations;
                this.index = 0;
                return;
            }
            Class<Annotation> supportedAnnotation = i$.next();
            supportedAnnotations.add(supportedAnnotation.getName());
        }
    }

    protected abstract Class<? extends MetaModelPlugin<?, ?>> getPluginType();

    protected abstract MetaModel<?, ?> createMetaModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block10: {
            if (!roundEnv.errorRaised()) {
                if (roundEnv.processingOver()) {
                    this.log.log("APT processing over");
                    this.log.log("Passivating model");
                    ((MetaModel)this.state.metaModel).prePassivate();
                    ObjectOutputStream out = null;
                    try {
                        FileObject file = this.getContext().createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "metamodel.ser", new Element[0]);
                        out = new ObjectOutputStream(file.openOutputStream());
                        out.writeObject(this.state);
                        this.state = null;
                        Object var6_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        Tools.safeClose(out);
                        throw throwable;
                    }
                    Tools.safeClose(out);
                    {
                        break block10;
                        catch (Exception e) {
                            e.printStackTrace();
                            this.log.log("Could not passivate model ", e);
                            Object var6_9 = null;
                            Tools.safeClose(out);
                            break block10;
                        }
                    }
                }
                this.log.log("Starting APT round #" + this.index);
                if (this.index == 0) {
                    this.log.log("Activating model");
                    ((MetaModel)this.state.metaModel).postActivate(this.getContext());
                }
                LinkedHashMap<AnnotationKey, AnnotationState> updates = new LinkedHashMap<AnnotationKey, AnnotationState>();
                for (TypeElement annotationElt : annotations) {
                    if (!this.supportedAnnotations.contains(annotationElt.getQualifiedName().toString())) continue;
                    this.log.log("Processing elements for annotation for " + annotationElt.getQualifiedName());
                    for (Element annotatedElt : roundEnv.getElementsAnnotatedWith(annotationElt)) {
                        if (annotatedElt.getAnnotation(Generated.class) != null) continue;
                        this.log.log("Processing element " + annotatedElt);
                        for (AnnotationMirror annotationMirror : annotatedElt.getAnnotationMirrors()) {
                            if (!annotationMirror.getAnnotationType().asElement().equals(annotationElt)) continue;
                            AnnotationKey key = new AnnotationKey(annotatedElt, annotationMirror);
                            AnnotationState state = AnnotationState.create(annotationMirror);
                            updates.put(key, state);
                        }
                    }
                }
                this.log.log("Process annotations");
                this.state.context.processAnnotations(updates.entrySet());
                this.log.log("Post processing model");
                ((MetaModel)this.state.metaModel).postProcessAnnotations();
                this.log.log("Process events");
                ((MetaModel)this.state.metaModel).processEvents();
                this.log.log("Post process events");
                ((MetaModel)this.state.metaModel).postProcessEvents();
                this.log.log("Ending APT round #" + this.index++);
            }
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        Iterable<Object> completions;
        if (element != null) {
            this.log.log("Activating model");
            ((MetaModel)this.state.metaModel).postActivate(this.getContext());
            AnnotationKey annotationKey = new AnnotationKey(element, Name.parse(((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString()));
            AnnotationState annotationState = AnnotationState.create(annotation);
            completions = this.state.context.getCompletions(annotationKey, annotationState, member.getSimpleName().toString(), userText);
        } else {
            completions = Collections.emptyList();
        }
        return completions != null ? completions : Collections.emptyList();
    }
}

