/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.ajax;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.plugin.ajax.Ajax;
import juzu.request.RenderContext;

public class AjaxPlugin
extends ApplicationPlugin
implements RequestFilter {
    Map<String, Method> table;
    @Inject
    ControllerPlugin controllerPlugin;
    @Inject
    @Named(value="juzu.asset_manager.script")
    AssetManager manager;

    public AjaxPlugin() {
        super("ajax");
    }

    public Descriptor init(PluginContext context) throws Exception {
        return context.getConfig() != null ? new Descriptor() : null;
    }

    @PostConstruct
    public void start() throws Exception {
        URL url = AjaxPlugin.class.getClassLoader().getResource("juzu/impl/plugin/ajax/script.js");
        if (url == null) {
            throw new Exception("Not found script.js");
        }
        this.manager.addAsset(new AssetMetaData("juzu.ajax", AssetLocation.APPLICATION, "/juzu/impl/plugin/ajax/script.js", "jquery"), url);
        HashMap<String, Method> table = new HashMap<String, Method>();
        for (Method cm : this.controllerPlugin.getDescriptor().getMethods()) {
            Ajax ajax = cm.getMethod().getAnnotation(Ajax.class);
            if (ajax == null) continue;
            table.put(cm.getName(), cm);
        }
        this.table = table;
    }

    public void invoke(final Request request) {
        Response response;
        request.invoke();
        if (request.getContext() instanceof RenderContext && (response = request.getResponse()) instanceof Response.Render) {
            Response.Render render = (Response.Render)response;
            PropertyMap properties = new PropertyMap(response.getProperties());
            properties.addValues(PropertyType.SCRIPT, "juzu.ajax");
            final Streamable decorated = render.getStreamable();
            Streamable<Stream.Char> decorator = new Streamable<Stream.Char>(){

                @Override
                public void send(Stream.Char stream) throws IOException {
                    stream.append("<div class=\"jz\">\n");
                    for (Map.Entry<String, Method> entry : AjaxPlugin.this.table.entrySet()) {
                        String baseURL = request.getContext().createDispatch(entry.getValue()).toString();
                        stream.append("<div data-method-id=\"");
                        stream.append(entry.getValue().getId());
                        stream.append("\" data-url=\"");
                        stream.append(baseURL);
                        stream.append("\"/>");
                        stream.append("</div>");
                    }
                    decorated.send(stream);
                    stream.append("</div>");
                }
            };
            request.setResponse(new Response.Render(properties, decorator));
        }
    }
}

