/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.MimeBridge;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.Formatting;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    PortletMimeBridge(Bridge bridge, Rq request, Rs response, PortletConfig config) {
        super(bridge, request, response, config);
    }

    @Override
    public void send() throws IOException, PortletException {
        if (this.response instanceof Response.Content) {
            Response.Content content = (Response.Content)this.response;
            String mimeType = content.getMimeType();
            if (mimeType != null) {
                ((MimeResponse)this.resp).setContentType(mimeType);
            }
            this.sendProperties();
            if (content.getKind() == Stream.Char.class) {
                content.send(Streams.closeable(((MimeResponse)this.resp).getWriter()));
            } else {
                content.send(new BinaryOutputStream(((MimeResponse)this.resp).getPortletOutputStream()));
            }
        } else if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            if (this.bridge.module.context.getRunMode().getPrettyFail()) {
                ((MimeResponse)this.resp).setContentType("text/html");
                PrintWriter writer = ((MimeResponse)this.resp).getWriter();
                writer.append("<div class=\"juzu\">");
                Throwable cause = error.getCause();
                if (cause != null) {
                    Formatting.renderThrowable(null, writer, cause);
                } else {
                    writer.append(error.getMessage());
                }
                writer.append("</div>");
                writer.close();
            } else {
                throw new PortletException(error.getCause());
            }
        }
    }
}

