/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.spi.web.ViewStreamable;
import juzu.impl.common.Formatting;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.io.Stream;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.RequestParameter;
import juzu.request.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebBridge {
    public static final PropertyType<Asset> STYLESHEET = new PropertyType<Asset>(){};
    public static final PropertyType<Asset> SCRIPT = new PropertyType<Asset>(){};

    public final void send(Response.Error error, boolean verbose) throws IOException {
        if (verbose) {
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            Formatting.renderStyleSheet(writer);
            writer.append("<div class=\"juzu\">");
            Throwable cause = error.getCause();
            if (cause != null) {
                Formatting.renderThrowable(null, writer, cause);
            } else {
                writer.append(error.getMessage());
            }
            writer.append("</div>");
            writer.close();
            this.send(Response.content(500, buffer.getBuffer()).withMimeType("text/html"), true);
        } else {
            this.setStatus(500);
        }
        if (verbose) {
            this.setContentType("text/html");
            Stream.Char writer = this.getOutputStream();
            writer.append(error.getMessage());
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Stream.Char send(Response.Content<Stream.Char> content, boolean bilto) throws IOException {
        Stream.Char writer;
        block8: {
            PropertyMap properties = content.getProperties();
            Integer status = content.getStatus();
            if (status != null) {
                this.setStatus(status);
            }
            this.setContentType(content.getMimeType());
            Iterable<Map.Entry<String, String[]>> headers = properties.getValues(PropertyType.HEADER);
            if (headers != null) {
                for (Map.Entry<String, String[]> entry : headers) {
                    this.setHeader(entry.getKey(), entry.getValue()[0]);
                }
            }
            writer = null;
            try {
                writer = this.getOutputStream();
                if (bilto) {
                    this.sendHeader(properties, writer);
                }
                if (content.getKind() == Stream.Char.class) {
                    ViewStreamable vs = new ViewStreamable(content.getStreamable(), bilto);
                    vs.send(writer);
                    break block8;
                }
                throw new UnsupportedOperationException("Not yet handled");
            }
            finally {
                this.end(writer);
            }
        }
        return writer;
    }

    protected void end(Stream.Char stream) {
        Tools.safeClose(stream);
    }

    private void sendHeader(PropertyMap properties, Stream.Char writer) throws IOException {
        Iterable<Asset> scripts;
        Iterable<Asset> stylesheets;
        Iterable<Map.Entry<String, String>> metaProps;
        writer.append("<!DOCTYPE html>\n");
        writer.append("<html>\n");
        writer.append("<head>\n");
        String title = properties.getValue(PropertyType.TITLE);
        if (title != null) {
            writer.append("<title>");
            writer.append(title);
            writer.append("</title>\n");
        }
        if ((metaProps = properties.getValues(PropertyType.META_TAG)) != null) {
            for (Map.Entry<String, String> meta : metaProps) {
                writer.append("<meta name=\"");
                writer.append(meta.getKey());
                writer.append("\" content=\"");
                writer.append(meta.getValue());
                writer.append("\">\n");
            }
        }
        if ((stylesheets = properties.getValues(STYLESHEET)) != null) {
            for (Asset stylesheet : stylesheets) {
                String path = stylesheet.getURI();
                int pos = path.lastIndexOf(46);
                String ext = pos == -1 ? "css" : path.substring(pos + 1);
                writer.append("<link rel=\"stylesheet\" type=\"text/");
                writer.append(ext);
                writer.append("\" href=\"");
                this.renderAssetURL(stylesheet.getLocation(), stylesheet.getURI(), writer);
                writer.append("\"></link>\n");
            }
        }
        if ((scripts = properties.getValues(SCRIPT)) != null) {
            for (Asset script : scripts) {
                writer.append("<script type=\"text/javascript\" src=\"");
                this.renderAssetURL(script.getLocation(), script.getURI(), writer);
                writer.append("\"></script>\n");
            }
        }
        writer.append("</head>\n");
        writer.append("<body>\n");
    }

    private void sendFooter(Writer writer) throws IOException {
        writer.append("</body>\n");
        writer.append("</html>\n");
    }

    public abstract Map<String, RequestParameter> getParameters();

    public abstract String getRequestURI();

    public abstract String getPath();

    public abstract String getRequestPath();

    public abstract void renderRequestURL(Appendable var1) throws IOException;

    public abstract void renderAssetURL(AssetLocation var1, String var2, Appendable var3) throws IOException;

    public abstract ScopedContext getRequestScope(boolean var1);

    public abstract ScopedContext getFlashScope(boolean var1);

    public abstract ScopedContext getSessionScope(boolean var1);

    public abstract void purgeSession();

    public abstract HttpContext getHttpContext();

    public abstract ClientContext getClientContext();

    public abstract UserContext getUserContext();

    public abstract void setContentType(String var1);

    public abstract void setStatus(int var1);

    public abstract void setHeader(String var1, String var2);

    public abstract void sendRedirect(String var1) throws IOException;

    public abstract Stream.Char getOutputStream() throws IOException;
}

