/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.PropertyType;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.asset.AssetDescriptor;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.StreamableDecorator;
import juzu.request.Phase;
import juzu.request.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPlugin
extends ApplicationPlugin
implements RequestFilter {
    private String[] scripts;
    private String[] declaredScripts;
    private String[] stylesheets;
    private String[] declaredStylesheets;
    private AssetDescriptor descriptor;
    private PluginContext context;
    private String assetsPath;
    @Inject
    @Named(value="juzu.asset_manager.script")
    AssetManager scriptManager;
    @Inject
    @Named(value="juzu.asset_manager.stylesheet")
    AssetManager stylesheetManager;

    public AssetPlugin() {
        super("asset");
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public String getAssetsPath() {
        return this.assetsPath;
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        String assetsPath;
        List<AssetMetaData> declaredStylesheets;
        List<AssetMetaData> stylesheets;
        List<AssetMetaData> declaredScripts;
        List<AssetMetaData> scripts;
        JSON config = context.getConfig();
        if (config != null) {
            String packageName = config.getString("package");
            AssetLocation location = AssetLocation.safeValueOf(config.getString("location"));
            if (location == null) {
                location = AssetLocation.APPLICATION;
            }
            scripts = this.load(packageName, location, config.getList("scripts", JSON.class));
            declaredScripts = this.load(packageName, location, config.getList("declaredScripts", JSON.class));
            stylesheets = this.load(packageName, location, config.getList("stylesheets", JSON.class));
            declaredStylesheets = this.load(packageName, location, config.getList("declaredStylesheets", JSON.class));
            assetsPath = "/" + Name.parse(this.application.getPackageName()).append(packageName).toString().replace('.', '/') + "/";
        } else {
            scripts = Collections.emptyList();
            declaredScripts = Collections.emptyList();
            stylesheets = Collections.emptyList();
            declaredStylesheets = Collections.emptyList();
            assetsPath = null;
        }
        this.descriptor = new AssetDescriptor(scripts, declaredScripts, stylesheets, declaredStylesheets);
        this.context = context;
        this.assetsPath = assetsPath;
        return this.descriptor;
    }

    private List<AssetMetaData> load(String packageName, AssetLocation defaultLocation, List<? extends JSON> scripts) throws Exception {
        List<AssetMetaData> abc = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            abc = new ArrayList<AssetMetaData>();
            for (JSON jSON : scripts) {
                String value;
                String id = jSON.getString("id");
                AssetLocation location = AssetLocation.safeValueOf(jSON.getString("location"));
                if (location == null) {
                    location = defaultLocation;
                }
                if (!(value = jSON.getString("src")).startsWith("/") && location == AssetLocation.APPLICATION) {
                    value = "/" + this.application.getPackageName().replace('.', '/') + "/" + packageName.replace('.', '/') + "/" + value;
                }
                AssetMetaData descriptor = new AssetMetaData(id, location, value, jSON.getArray("depends", String.class));
                abc.add(descriptor);
            }
        }
        return abc;
    }

    @PostConstruct
    public void start() throws Exception {
        this.scripts = this.process(this.descriptor.getScripts(), this.scriptManager);
        this.declaredScripts = this.process(this.descriptor.getDeclaredScripts(), this.scriptManager);
        this.stylesheets = this.process(this.descriptor.getStylesheets(), this.stylesheetManager);
        this.declaredStylesheets = this.process(this.descriptor.getDeclaredStylesheets(), this.stylesheetManager);
    }

    public URL resolve(AssetLocation location, String path) {
        switch (location) {
            case APPLICATION: {
                return this.context.getApplicationResolver().resolve(path);
            }
            case SERVER: {
                return this.context.getServerResolver().resolve(path);
            }
        }
        return null;
    }

    private String[] process(List<AssetMetaData> data, AssetManager manager) throws Exception {
        ArrayList<String> assets = new ArrayList<String>();
        for (AssetMetaData script : data) {
            URL url;
            AssetLocation location = script.getLocation();
            if (location == AssetLocation.APPLICATION) {
                url = this.resolve(AssetLocation.APPLICATION, script.getValue());
                if (url == null) {
                    throw new Exception("Could not resolve application  " + script.getValue());
                }
            } else if (location == AssetLocation.SERVER) {
                if (!script.getValue().startsWith("/")) {
                    url = this.resolve(AssetLocation.SERVER, "/" + script.getValue());
                    if (url == null) {
                        throw new Exception("Could not resolve server asset " + script.getValue());
                    }
                } else {
                    url = null;
                }
            } else {
                url = null;
            }
            String id = manager.addAsset(script, url);
            assets.add(id);
        }
        return assets.toArray(new String[assets.size()]);
    }

    @Override
    public void invoke(Request request) {
        Result result;
        request.invoke();
        if (request.getPhase() == Phase.VIEW && (result = request.getResult()) instanceof Result.Status) {
            Result.Status status = (Result.Status)result;
            if (status.decorated && (this.scripts.length > 0 || this.stylesheets.length > 0)) {
                status = new Result.Status(status.code, true, new StreamableDecorator(status.streamable){

                    protected void sendHeader(Stream consumer) {
                        for (String stylesheet : AssetPlugin.this.stylesheets) {
                            consumer.provide(new Chunk.Property<String>(stylesheet, PropertyType.STYLESHEET));
                        }
                        for (String script : AssetPlugin.this.scripts) {
                            consumer.provide(new Chunk.Property<String>(script, PropertyType.SCRIPT));
                        }
                    }
                });
                request.setResult(status);
            }
        }
    }
}

