/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.provided;

import java.io.IOException;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.cdi.provided.ProvidedCDIInjector;
import juzu.impl.plugin.application.Application;
import juzu.impl.resource.ResourceResolver;

public class ProvidedBridge
extends Bridge {
    private Application application;
    private BeanLifeCycle applicationLifeCycle;

    public ProvidedBridge(BridgeContext context, Logger log, BridgeConfig config, AssetServer server, ResourceResolver resolver) {
        super(context, log, config, server, resolver);
    }

    public RunMode getRunMode() {
        return RunMode.DEV;
    }

    public boolean refresh(boolean recompile) throws Exception {
        if (this.application == null) {
            ProvidedCDIInjector injector = (ProvidedCDIInjector)this.config.injectorProvider.get(true);
            this.application = injector.getApplication();
            this.applicationLifeCycle = this.application.getInjectionContext().get(Application.class);
            this.applicationLifeCycle.get();
            this.server.register(this.application);
        }
        return false;
    }

    public Application getApplication() {
        return this.application;
    }

    public void close() throws IOException {
        Tools.safeClose(this.applicationLifeCycle);
        this.applicationLifeCycle = null;
    }
}

