/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.InputStream;
import juzu.PropertyType;

public abstract class Chunk {
    public static Data.Char create(char c) {
        return new Data.Char(c);
    }

    public static Data.CharSequence create(CharSequence data) {
        return Chunk.create(data, 0, data.length());
    }

    public static Data.CharSequence create(CharSequence data, int start, int end) {
        return new Data.CharSequence(data, start, end);
    }

    public static Data.InputStream create(InputStream data) {
        return new Data.InputStream(data);
    }

    public static Data.Readable create(Readable data) {
        return new Data.Readable(data);
    }

    public static Data.Chars create(char[] data) {
        return new Data.Chars(data);
    }

    public static Data.Bytes create(byte[] data) {
        return new Data.Bytes(data);
    }

    public static class Data
    extends Chunk {

        public static class Bytes
        extends Data {
            public final byte[] data;

            private Bytes(byte[] data) {
                this.data = data;
            }
        }

        public static class Chars
        extends Data {
            public final char[] data;

            private Chars(char[] data) {
                this.data = data;
            }
        }

        public static class CharSequence
        extends Data {
            public final java.lang.CharSequence data;
            public final int start;
            public final int end;

            private CharSequence(java.lang.CharSequence data, int start, int end) {
                this.data = data;
                this.start = start;
                this.end = end;
            }
        }

        public static class Char
        extends Data {
            public final char value;

            public Char(char value) {
                this.value = value;
            }
        }

        public static class InputStream
        extends Data {
            public final java.io.InputStream data;

            private InputStream(java.io.InputStream data) {
                this.data = data;
            }
        }

        public static class Readable
        extends Data {
            public final java.lang.Readable data;

            private Readable(java.lang.Readable data) {
                this.data = data;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Property<T>
    extends Chunk {
        public final T value;
        public final PropertyType<T> type;

        public Property(T value, PropertyType<T> type) {
            if (type == null) {
                throw new NullPointerException("Property type cannot be null for value " + value);
            }
            if (value == null) {
                throw new NullPointerException("Property value cannot be null for type " + type);
            }
            this.value = value;
            this.type = type;
        }
    }
}

