/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.runtime;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.asset.AssetPlugin;
import juzu.impl.resource.ResourceResolver;
import juzu.impl.runtime.ModuleRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRuntime<P, R>
implements Closeable {
    private final Name name;
    private final Injector injectorProvider;
    private final Logger log;
    private final ResourceResolver resourceResolver;
    private final AssetServer assetServer;
    private final ModuleRuntime<?> moduleLifeCycle;
    private ApplicationDescriptor descriptor;
    private AssetManager assetManager;
    private InjectionContext<?, ?> injectionContext;
    private Application application;
    private ClassLoader classLoader;

    public ApplicationRuntime(Logger log, ModuleRuntime<?> moduleLifeCycle, Injector injectorProvider, Name name, AssetServer assetServer, ResourceResolver resourceResolver) {
        this.log = log;
        this.moduleLifeCycle = moduleLifeCycle;
        this.injectorProvider = injectorProvider;
        this.name = name;
        this.assetServer = assetServer;
        this.resourceResolver = resourceResolver;
    }

    public Name getName() {
        return this.name;
    }

    public Application getApplication() {
        return this.application != null ? this.application : null;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public <T> T resolveBean(Class<T> beanType) {
        return this.injectionContext.resolveInstance(beanType);
    }

    public <T> Iterable<T> resolveBeans(Class<T> beanType) {
        return this.injectionContext.resolveInstances(beanType);
    }

    public boolean refresh() throws Exception {
        if (this.application != null && this.classLoader != this.moduleLifeCycle.getClassLoader()) {
            this.stop();
        }
        if (this.application == null) {
            this.log.log("Building application");
            this.start();
            return true;
        }
        return false;
    }

    protected final void start() throws Exception {
        ReadFileSystem<?> classes = this.moduleLifeCycle.getClasses();
        Name fqn = this.name.append("Application");
        Class<?> clazz = this.moduleLifeCycle.getClassLoader().loadClass(fqn.toString());
        ApplicationDescriptor descriptor = ApplicationDescriptor.create(clazz);
        Injector injector = this.injectorProvider.get();
        injector.addFileSystem(classes);
        injector.setClassLoader(this.moduleLifeCycle.getClassLoader());
        this.log.log("Starting " + descriptor.getName());
        Application application = new Application(injector, descriptor, this.resourceResolver);
        application.start();
        InjectionContext<?, ?> injectionContext = application.getInjectionContext();
        AssetPlugin assetPlugin = injectionContext.get(AssetPlugin.class).get();
        if (this.assetServer != null) {
            this.assetServer.register(application);
        }
        this.injectionContext = injectionContext;
        this.assetManager = assetPlugin.getAssetManager();
        this.descriptor = descriptor;
        this.application = application;
        this.classLoader = this.moduleLifeCycle.getClassLoader();
        BeanLifeCycle<Application> lf = injectionContext.get(Application.class);
        try {
            lf.get();
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        finally {
            lf.close();
        }
    }

    void stop() {
        if (this.assetServer != null) {
            this.assetServer.unregister(this.application);
        }
        Tools.safeClose(this.injectionContext);
        this.application = null;
        this.injectionContext = null;
        this.assetManager = null;
        this.descriptor = null;
        this.classLoader = null;
    }

    @Override
    public void close() {
        this.stop();
    }
}

