/*
 * Copyright 2013 eXo Platform SAS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package inject.lifecycle.singleton;

import juzu.Scope;
import inject.AbstractInjectTestCase;
import juzu.impl.inject.spi.InjectorProvider;
import org.junit.Test;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public class LifeCycleSingletonTestCase<B, I> extends AbstractInjectTestCase<B, I> {

  public LifeCycleSingletonTestCase(InjectorProvider di) {
    super(di);
  }

  @Test
  public void test() throws Exception {
    init();
    bootstrap.declareBean(Bean.class, null, null, null);
    boot(Scope.SESSION);

    //
    Bean.construct = 0;
    Bean.destroy = 0;

    //
    beginScoping();
    try {
      B bean = mgr.resolveBean(Bean.class);
      I instance = mgr.createContext(bean);
      Bean o = (Bean)mgr.getInstance(bean, instance);
      assertNotNull(o);
      assertEquals(1, Bean.construct);
      assertEquals(0, Bean.destroy);
      mgr.releaseContext(bean, instance);
      assertEquals(1, Bean.construct);
      assertEquals(0, Bean.destroy);
    }
    finally {
      endScoping();
    }
    assertEquals(1, Bean.construct);
    assertEquals(0, Bean.destroy);

    //
    mgr.close();
    assertEquals(1, Bean.construct);
    assertEquals(1, Bean.destroy);
  }
}
