/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.DeclaredBean;
import juzu.impl.inject.spi.cdi.DeclaredProviderBean;
import juzu.impl.inject.spi.cdi.SingletonBean;
import juzu.impl.inject.spi.cdi.SingletonProviderBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDIInjector
extends Injector {
    protected final Set<Scope> scopes;
    protected final ArrayList<AbstractBean> boundBeans;
    protected final ScopeController scopeController;

    public CDIInjector() {
        this.scopes = new HashSet<Scope>();
        this.boundBeans = new ArrayList();
        this.scopeController = new ScopeController();
    }

    public CDIInjector(CDIInjector that) {
        this.scopes = new HashSet<Scope>(that.scopes);
        this.boundBeans = new ArrayList<AbstractBean>(that.boundBeans);
        this.scopeController = that.scopeController;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    @Override
    public <T> Injector declareBean(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends T> implementationType) {
        this.boundBeans.add(new DeclaredBean(implementationType != null ? implementationType : type, beanScope, qualifiers));
        return this;
    }

    @Override
    public <T> Injector declareProvider(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends Provider<T>> provider) {
        this.boundBeans.add(new DeclaredProviderBean(type, beanScope, qualifiers, provider));
        return this;
    }

    @Override
    public Injector addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public <T> Injector bindBean(Class<T> type, Iterable<Annotation> qualifiers, T instance) {
        this.boundBeans.add(new SingletonBean(type, qualifiers, instance));
        return this;
    }

    @Override
    public <T> Injector bindProvider(Class<T> beanType, Scope beanScope, Iterable<Annotation> beanQualifiers, Provider<? extends T> provider) {
        this.boundBeans.add(new SingletonProviderBean(beanType, beanScope, beanQualifiers, provider));
        return this;
    }
}

