/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetNode {
    private static final Set<String> EMPTY_SET = Collections.emptySet();
    final String id;
    final AssetLocation location;
    final List<String> value;
    final List<Asset> assets;
    Set<String> dependsOnMe;
    Set<String> iDependOn;

    public AssetNode(String id, AssetLocation location, List<String> value, Set<String> iDependOn) {
        ArrayList<Asset> assets = new ArrayList<Asset>(value.size());
        for (String v : value) {
            assets.add(Asset.of(location, v));
        }
        this.id = id;
        this.location = location;
        this.value = value;
        this.dependsOnMe = EMPTY_SET;
        this.iDependOn = iDependOn;
        this.assets = assets;
    }

    public String getId() {
        return this.id;
    }

    public AssetLocation getLocation() {
        return this.location;
    }

    public List<String> getValue() {
        return this.value;
    }
}

