/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.compiler;

import juzu.impl.common.Location;
import juzu.impl.template.spi.juzu.DialectTemplateEmitter;
import juzu.impl.template.spi.juzu.ast.SectionType;

class EmitterContext {
    private SectionType currentType = null;
    private StringBuilder accumulatedText = new StringBuilder();
    final DialectTemplateEmitter writer;

    EmitterContext(DialectTemplateEmitter writer) {
        this.writer = writer;
    }

    void open() {
        this.writer.open();
    }

    void close() {
        this.writer.close();
    }

    void openSection(SectionType sectionType, Location pos) {
        if (sectionType == null) {
            throw new NullPointerException();
        }
        if (pos == null) {
            throw new NullPointerException();
        }
        if (this.currentType != null) {
            throw new IllegalStateException();
        }
        this.currentType = sectionType;
        switch (this.currentType) {
            case STRING: {
                break;
            }
            case SCRIPTLET: {
                this.writer.openScriptlet(pos);
                break;
            }
            case EXPR: {
                this.writer.openExpression(pos);
            }
        }
    }

    void appendText(String text) {
        switch (this.currentType) {
            case STRING: {
                this.accumulatedText.append(text);
                break;
            }
            case SCRIPTLET: {
                this.writer.appendScriptlet(text);
                break;
            }
            case EXPR: {
                this.writer.appendExpression(text);
            }
        }
    }

    void appendLineBreak(Location position) {
        switch (this.currentType) {
            case STRING: {
                this.accumulatedText.append("\n");
                break;
            }
            case SCRIPTLET: {
                this.writer.appendLineBreak(this.currentType, position);
                break;
            }
            case EXPR: {
                this.writer.appendLineBreak(this.currentType, position);
            }
        }
    }

    void closeSection() {
        if (this.currentType == null) {
            throw new IllegalStateException();
        }
        switch (this.currentType) {
            case STRING: {
                if (this.accumulatedText.length() <= 0) break;
                this.writer.appendText(this.accumulatedText.toString());
                this.accumulatedText.setLength(0);
                break;
            }
            case SCRIPTLET: {
                this.writer.closeScriptlet();
                break;
            }
            case EXPR: {
                this.writer.closeExpression();
            }
        }
        this.currentType = null;
    }
}

