/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.provided;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.BridgeContext;
import juzu.impl.common.Completion;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.provided.ProvidedCDIInjector;
import juzu.impl.plugin.application.Application;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvidedBridge
extends Bridge {
    private Application application;
    private BeanLifeCycle applicationLifeCycle;
    private final Injector injector;

    public ProvidedBridge(BridgeContext context, BridgeConfig config, AssetServer server, ResourceResolver resolver, Injector injector) {
        super(context, config, server, resolver);
        this.injector = injector;
    }

    @Override
    public RunMode getRunMode() {
        return RunMode.DEV;
    }

    @Override
    public Completion<Boolean> refresh(boolean recompile) {
        if (this.application == null) {
            ProvidedCDIInjector injector = (ProvidedCDIInjector)this.injector;
            this.application = injector.getApplication();
            this.applicationLifeCycle = this.application.getInjectionContext().get(Application.class);
            try {
                this.applicationLifeCycle.get();
            }
            catch (InvocationTargetException e) {
                return Completion.failed(e);
            }
            this.server.register(this.application);
        }
        return Completion.completed(false);
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public void close() throws IOException {
        Tools.safeClose(this.applicationLifeCycle);
        this.applicationLifeCycle = null;
    }
}

