/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import juzu.impl.compiler.Message;
import juzu.impl.compiler.MessageCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingException
extends RuntimeException
implements Iterable<Message> {
    private final List<Message> messages;
    private final Element element;
    private final AnnotationMirror annotation;

    public ProcessingException(MessageCode code, Object ... arguments) {
        this(null, code, arguments);
    }

    public ProcessingException(Element element, MessageCode messageCode, Object ... arguments) {
        this(element, null, messageCode, arguments);
    }

    public ProcessingException(List<Message> messages) {
        this(null, null, messages);
    }

    public ProcessingException(Element element, List<Message> messages) {
        this(element, null, messages);
    }

    public ProcessingException(Element element, AnnotationMirror annotation, MessageCode code, Object ... arguments) {
        this(element, annotation, Collections.singletonList(new Message(code, arguments)));
    }

    public ProcessingException(Element element, AnnotationMirror annotation, List<Message> messages) {
        this.element = element;
        this.annotation = annotation;
        this.messages = messages;
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    @Override
    public ProcessingException initCause(Throwable cause) {
        return (ProcessingException)super.initCause(cause);
    }

    public Element getElement() {
        return this.element;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public List<Message> getMessages() {
        return this.messages;
    }
}

