/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.impl.common.Formatting;
import juzu.impl.compiler.CompilationException;
import juzu.io.OutputStream;
import juzu.io.Stream;
import juzu.request.ClientContext;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletViewBridge
extends PortletMimeBridge<RenderRequest, RenderResponse> {
    public PortletViewBridge(Bridge bridge, RenderRequest request, RenderResponse response, PortletConfig config) {
        super(bridge, Phase.VIEW, request, response, config);
    }

    @Override
    public Stream createStream(String mimeType, Charset charset) throws IOException {
        if (mimeType != null) {
            ((RenderResponse)this.resp).setContentType(mimeType);
        }
        return OutputStream.create(charset, ((RenderResponse)this.resp).getWriter());
    }

    @Override
    public ClientContext getClientContext() {
        return null;
    }

    @Override
    public void invoke() throws Exception {
        try {
            this.bridge.refresh();
        }
        catch (CompilationException e) {
            StringWriter buffer = new StringWriter();
            PrintWriter printer = new PrintWriter(buffer);
            Formatting.renderErrors(printer, e.getErrors());
            this.setResult(Response.error(buffer.toString()).result());
            return;
        }
        super.invoke();
    }
}

