/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import juzu.Method;
import juzu.Resource;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.web.WebActionBridge;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRequestBridge;
import juzu.impl.bridge.spi.web.WebResourceBridge;
import juzu.impl.bridge.spi.web.WebViewBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.UriBuilder;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.router.RouteDescriptor;
import juzu.impl.plugin.router.RouterDescriptor;
import juzu.impl.plugin.router.RouterPlugin;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.request.Phase;
import juzu.request.RequestParameter;

public class Handler
implements Closeable {
    private static final Phase[] GET_PHASES = new Phase[]{Phase.VIEW, Phase.ACTION, Phase.RESOURCE};
    private static final Phase[] POST_PHASES = new Phase[]{Phase.ACTION, Phase.VIEW, Phase.RESOURCE};
    private static final Phase[] OTHER_PHASES = new Phase[]{Phase.RESOURCE};
    final Bridge bridge;
    final Route root;
    final HashMap<MethodHandle, Route> forwardRoutes;
    final HashMap<Route, RouteDescriptor> backwardRoutes;

    public Handler(Bridge bridge) throws Exception {
        RouterDescriptor desc;
        this.bridge = bridge;
        HashMap<MethodHandle, Route> forwardRoutes = new HashMap<MethodHandle, Route>();
        HashMap<Route, RouteDescriptor> backwardRoutes = new HashMap<Route, RouteDescriptor>();
        Router root = new Router();
        RouterPlugin router = bridge.getApplication().resolveBean(RouterPlugin.class);
        if (router != null && (desc = router.getDescriptor()) != null) {
            Map<RouteDescriptor, Route> ret = desc.popupate(root);
            for (Map.Entry<RouteDescriptor, Route> entry : ret.entrySet()) {
                forwardRoutes.put(entry.getKey().handle, entry.getValue());
                backwardRoutes.put(entry.getValue(), entry.getKey());
            }
        }
        this.forwardRoutes = forwardRoutes;
        this.backwardRoutes = backwardRoutes;
        this.root = root;
    }

    public RouteDescriptor getMethods(Route route) {
        return this.backwardRoutes.get(route);
    }

    public Route getRoute(MethodHandle method) {
        return this.forwardRoutes.get(method);
    }

    public Route getRoot() {
        return this.root;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public void handle(WebBridge bridge) throws Throwable {
        String requestPath = bridge.getRequestContext().getRequestPath();
        juzu.impl.request.Method requestTarget = null;
        RouteMatch requestMatch = null;
        Map<String, RequestParameter> requestParameters = Collections.emptyMap();
        if (requestPath.startsWith(bridge.getRequestContext().getPath())) {
            Method requestMethod = bridge.getHttpContext().getMethod();
            Iterator<RouteMatch> matches = this.root.matcher(requestPath.substring(bridge.getRequestContext().getPath().length()), Collections.<String, String[]>emptyMap());
            while (matches.hasNext()) {
                RouteMatch match = matches.next();
                RouteDescriptor routeDescriptor = this.getMethods(match.getRoute());
                if (routeDescriptor == null) continue;
                juzu.impl.request.Method target = this.bridge.getApplication().resolveBean(ControllerPlugin.class).getDescriptor().getMethodByHandle(routeDescriptor.handle);
                if (target.getPhase() == Phase.VIEW) {
                    if (requestMethod == Method.POST) {
                        requestTarget = target;
                        requestMatch = match;
                        continue;
                    }
                    if (requestMethod != Method.GET) continue;
                    requestTarget = target;
                    requestMatch = match;
                    break;
                }
                if (target.getPhase() == Phase.ACTION) {
                    if (requestMethod == Method.GET) {
                        requestTarget = target;
                        requestMatch = match;
                        continue;
                    }
                    if (requestMethod != Method.POST) continue;
                    requestTarget = target;
                    requestMatch = match;
                    break;
                }
                if (target.getPhase() != Phase.RESOURCE || !Arrays.asList(target.getMethod().getAnnotation(Resource.class).method()).contains((Object)requestMethod)) continue;
                requestTarget = target;
                requestMatch = match;
                break;
            }
            if (requestMatch != null && (requestMatch.getMatched().size() > 0 || bridge.getRequestContext().getParameters().size() > 0)) {
                requestParameters = new HashMap<String, RequestParameter>();
                for (RequestParameter requestParameter : bridge.getRequestContext().getParameters().values()) {
                    requestParameters.put(requestParameter.getName(), requestParameter);
                }
                for (Map.Entry entry : requestMatch.getMatched().entrySet()) {
                    RequestParameter requestParameter = RequestParameter.create(((PathParam)entry.getKey()).getName(), (String)entry.getValue());
                    requestParameters.put(requestParameter.getName(), requestParameter);
                }
            }
        }
        if (requestTarget == null) {
            requestTarget = this.bridge.getApplication().resolveBean(ControllerPlugin.class).getResolver().resolve(Phase.VIEW, Collections.<String>emptySet());
        }
        if (requestTarget == null) {
            bridge.getRequestContext().setStatus(404);
        } else {
            WebRequestBridge requestBridge;
            Route requestRoute;
            if (requestMatch == null && (requestRoute = this.getRoute(requestTarget.getHandle())) != null && (requestMatch = requestRoute.matches(Collections.<String, String>emptyMap())) != null) {
                StringBuilder sb = new StringBuilder();
                requestMatch.render(new UriBuilder(sb));
                if (!sb.toString().equals(requestPath)) {
                    StringBuilder redirect = new StringBuilder();
                    bridge.renderRequestURL(redirect);
                    redirect.append((CharSequence)sb);
                    bridge.getRequestContext().sendRedirect(redirect.toString());
                    return;
                }
            }
            if (requestTarget.getPhase() == Phase.ACTION) {
                requestBridge = new WebActionBridge(this.bridge, this, bridge, requestTarget, requestParameters);
            } else if (requestTarget.getPhase() == Phase.VIEW) {
                requestBridge = new WebViewBridge(this.bridge, this, bridge, requestTarget, requestParameters);
            } else if (requestTarget.getPhase() == Phase.RESOURCE) {
                requestBridge = new WebResourceBridge(this.bridge, this, bridge, requestTarget, requestParameters);
            } else {
                throw new Exception("Cannot decode phase");
            }
            requestBridge.invoke();
            if (!requestBridge.send()) {
                throw new UnsupportedOperationException("Not yet handled by " + requestBridge.getClass().getSimpleName() + ": " + requestBridge.response);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

