/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.MethodMetaModel;
import juzu.request.Phase;

class ControllerMetaModelResolver
extends ControllerResolver<MethodMetaModel> {
    private final ControllersMetaModel controllers;
    private final MethodMetaModel[] methods;
    private final int size;

    ControllerMetaModelResolver(ControllersMetaModel controllers) throws NullPointerException {
        int size = 0;
        ArrayList<MethodMetaModel> methods = new ArrayList<MethodMetaModel>();
        for (ControllerMetaModel controller : controllers.getChildren(ControllerMetaModel.class)) {
            ++size;
            for (MethodMetaModel method : controller.getMethods()) {
                methods.add(method);
            }
        }
        this.controllers = controllers;
        this.methods = methods.toArray(new MethodMetaModel[methods.size()]);
        this.size = size;
    }

    public MethodMetaModel[] getMethods() {
        return this.methods;
    }

    @Override
    public String getId(MethodMetaModel method) {
        return method.getId();
    }

    @Override
    public Phase getPhase(MethodMetaModel method) {
        return method.getPhase();
    }

    @Override
    public String getName(MethodMetaModel method) {
        return method.getName();
    }

    @Override
    public boolean isDefault(MethodMetaModel method) {
        return method.getController().getHandle().getName().equals(this.controllers.defaultController) || this.size < 2;
    }

    @Override
    public Collection<String> getParameterNames(MethodMetaModel method) {
        return method.getParameterNames();
    }
}

