/*
 * Decompiled with CFR 0.152.
 */
package juzu.request;

import java.util.AbstractList;
import java.util.Map;
import juzu.io.Encoding;

public class ResponseParameter
extends AbstractList<String> {
    final Encoding encoding;
    final String name;

    public static ResponseParameter create(String name, String value) {
        return ResponseParameter.create(Encoding.RFC3986, name, value);
    }

    public static ResponseParameter create(String name, String ... value) {
        return ResponseParameter.create(Encoding.RFC3986, name, value);
    }

    public static ResponseParameter create(Encoding encoded, String name, String value) {
        return new SingleValued(encoded, name, value);
    }

    public static ResponseParameter create(Encoding encoded, String name, String ... value) {
        return new MultiValued(encoded, name, value);
    }

    @Override
    public String get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    private ResponseParameter(Encoding encoding, String name) {
        this.encoding = encoding;
        this.name = name;
    }

    public <M extends Map<String, ResponseParameter>> M addTo(M map) {
        map.put((String)this.name, (ResponseParameter)this);
        return map;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public String getName() {
        return this.name;
    }

    public String[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "Parameter[name=" + this.name + ",value=" + super.toString() + "]";
    }

    private static class MultiValued
    extends ResponseParameter {
        private final String[] value;

        private MultiValued(Encoding encoding, String name, String[] value) {
            super(encoding, name);
            this.value = value;
        }

        @Override
        public String get(int index) {
            if (index < 0 || index > this.value.length) {
                throw new IndexOutOfBoundsException("Wrong index " + index);
            }
            return this.value[index];
        }

        @Override
        public int size() {
            return this.value.length;
        }

        @Override
        public String[] toArray() {
            return (String[])this.value.clone();
        }
    }

    private static class SingleValued
    extends ResponseParameter {
        private final String value;

        private SingleValued(Encoding encoded, String name, String value) {
            super(encoded, name);
            this.value = value;
        }

        @Override
        public String get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Wrong index " + index);
            }
            return this.value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String[] toArray() {
            return new String[]{this.value};
        }
    }
}

