/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.portlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import juzu.Consumes;
import juzu.PropertyType;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.module.ApplicationBridge;
import juzu.impl.bridge.module.ModuleContextImpl;
import juzu.impl.bridge.provided.ProvidedBridge;
import juzu.impl.bridge.spi.portlet.PortletActionBridge;
import juzu.impl.bridge.spi.portlet.PortletEventBridge;
import juzu.impl.bridge.spi.portlet.PortletResourceBridge;
import juzu.impl.bridge.spi.portlet.PortletViewBridge;
import juzu.impl.bridge.spi.servlet.AbstractBridgeContext;
import juzu.impl.common.JUL;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.inject.spi.spring.SpringInjector;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.request.ControllerHandler;
import juzu.impl.resource.ResourceResolver;
import juzu.request.Phase;

public class JuzuPortlet
implements Portlet,
ResourceServingPortlet,
EventPortlet {
    public static final PropertyType<PortletMode> PORTLET_MODE = new PropertyType<PortletMode>(){};
    public static final PropertyType<WindowState> WINDOW_STATE = new PropertyType<WindowState>(){};
    private Bridge bridge;
    private PortletConfig config;
    private boolean initialized = false;

    public void init(final PortletConfig config) throws PortletException {
        BridgeConfig bridgeConfig;
        final PortletContext context = config.getPortletContext();
        AssetServer server = (AssetServer)context.getAttribute("asset.server");
        if (server == null) {
            server = new AssetServer();
            context.setAttribute("asset.server", (Object)server);
        }
        Logger portletLogger = JUL.getLogger(JuzuPortlet.class.getName() + "." + config.getPortletName());
        try {
            bridgeConfig = new BridgeConfig(portletLogger, (Map<String, String>)new SimpleMap<String, String>(){

                @Override
                protected Iterator<String> keys() {
                    return BridgeConfig.NAMES.iterator();
                }

                @Override
                public String get(Object key) {
                    if ("juzu.app_name".equals(key)) {
                        return JuzuPortlet.this.getApplicationName(config);
                    }
                    if ("juzu.inject".equals(key)) {
                        String inject = config.getInitParameter((String)key);
                        if (inject == null) {
                            inject = context.getInitParameter((String)key);
                        }
                        return inject;
                    }
                    if (BridgeConfig.NAMES.contains(key)) {
                        return config.getInitParameter((String)key);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String msg = "Could not find an application to start";
            if (e instanceof PortletException) {
                String nested = e.getMessage();
                if (nested != null) {
                    msg = msg + ":" + nested;
                }
                throw Tools.initCause(new UnavailableException(msg), e.getCause());
            }
            throw new PortletException(msg, (Throwable)e);
        }
        AbstractBridgeContext bridgeContext = new AbstractBridgeContext(){
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            final ResourceResolver resolver = new ResourceResolver(){

                @Override
                public URL resolve(String uri) {
                    try {
                        return context.getResource(uri);
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
            };

            @Override
            public ReadFileSystem<?> getResourcePath() {
                return WarFileSystem.create(context, "/WEB-INF/");
            }

            @Override
            public ReadFileSystem<?> getClassPath() {
                return WarFileSystem.create(context, "/WEB-INF/classes/");
            }

            @Override
            public ClassLoader getClassLoader() {
                return this.classLoader;
            }

            @Override
            public String getInitParameter(String name) {
                return context.getInitParameter(name);
            }

            @Override
            public ResourceResolver getResolver() {
                return this.resolver;
            }

            @Override
            public Object getAttribute(String key) {
                return context.getAttribute(key);
            }

            @Override
            public void setAttribute(String key, Object value) {
                context.setAttribute(key, value);
            }
        };
        InjectorProvider injectorProvider = bridgeConfig.injectorProvider;
        if (injectorProvider == null) {
            throw new UnavailableException("No inject implementation selected");
        }
        portletLogger.info("Using inject implementation " + injectorProvider.getValue());
        Injector injector = injectorProvider.get();
        if (injector instanceof SpringInjector) {
            SpringInjector springInjector = (SpringInjector)injector;
            Object parent = context.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
            if (parent != null) {
                springInjector.setParent(parent);
            }
        }
        ResourceResolver resolver = new ResourceResolver(){

            @Override
            public URL resolve(String uri) {
                try {
                    return context.getResource(uri);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        };
        ModuleContextImpl module = (ModuleContextImpl)context.getAttribute("juzu.module");
        if (module == null) {
            module = new ModuleContextImpl(portletLogger, bridgeContext, resolver);
            context.setAttribute("juzu.module", (Object)module);
        }
        Bridge bridge = injector.isProvided() ? new ProvidedBridge(bridgeContext, bridgeConfig, server, resolver, injector) : new ApplicationBridge(module, bridgeContext, bridgeConfig, server, resolver, injector);
        this.config = config;
        this.bridge = bridge;
    }

    protected String getApplicationName(PortletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private void rethrow(Throwable e) throws PortletException, IOException {
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new PortletException(e);
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, IOException {
        try {
            PortletActionBridge requestBridge = new PortletActionBridge(this.bridge, req, resp, this.config);
            requestBridge.invoke();
            requestBridge.send();
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        ControllerResolver<ControllerHandler> resolver = this.bridge.getApplication().resolveBean(ControllerPlugin.class).getDescriptor().getResolver();
        List<ControllerHandler> handlers = resolver.resolveMethods(Phase.EVENT, null, request.getParameterMap().keySet());
        ControllerHandler target = null;
        for (ControllerHandler handler : handlers) {
            Consumes consumes = handler.getMethod().getAnnotation(Consumes.class);
            if (consumes.value().equals("")) {
                target = handler;
                continue;
            }
            if (!consumes.value().equals(request.getEvent().getName())) continue;
            target = handler;
            break;
        }
        if (target != null) {
            try {
                PortletEventBridge requestBridge = new PortletEventBridge(this.bridge, request, response, this.config, target, request.getParameterMap());
                requestBridge.invoke();
                requestBridge.send();
            }
            catch (Throwable e) {
                this.rethrow(e);
            }
        } else {
            response.setRenderParameters(request);
        }
    }

    public void render(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        if (!this.initialized) {
            try {
                this.bridge.refresh();
                this.initialized = true;
            }
            catch (Exception e) {
                String msg = "Could not initialize application";
                if (e instanceof PortletException) {
                    String nested = e.getMessage();
                    if (nested != null) {
                        msg = msg + ":" + nested;
                    }
                    throw new PortletException(msg, e.getCause());
                }
                throw new PortletException(msg, (Throwable)e);
            }
        }
        try {
            PortletViewBridge requestBridge = new PortletViewBridge(this.bridge, req, resp, this.config);
            requestBridge.invoke();
            requestBridge.send();
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    public void serveResource(ResourceRequest req, ResourceResponse resp) throws PortletException, IOException {
        if (!this.initialized) {
            try {
                this.bridge.refresh();
                this.initialized = true;
            }
            catch (Exception e) {
                String msg = "Could not initialize application";
                if (e instanceof PortletException) {
                    String nested = e.getMessage();
                    if (nested != null) {
                        msg = msg + ":" + nested;
                    }
                    throw new PortletException(msg, e.getCause());
                }
                throw new PortletException(msg, (Throwable)e);
            }
        }
        try {
            PortletResourceBridge requestBridge = new PortletResourceBridge(this.bridge, req, resp, this.config);
            requestBridge.invoke();
            requestBridge.send();
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    public void destroy() {
        Tools.safeClose(this.bridge);
    }
}

