/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import juzu.impl.common.JSONParser;
import juzu.impl.common.ParseException;

public final class JSON
implements Serializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set<Class<?>> simpleTypes = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Boolean.class));
    private final TreeMap<String, Object> entries = new TreeMap();

    public static JSON json() {
        return new JSON();
    }

    public Set<String> names() {
        return this.entries.keySet();
    }

    public Object get(String name) {
        return this.entries.get(name);
    }

    public String getString(String name) {
        return (String)this.entries.get(name);
    }

    public List<?> getList(String name) {
        return (List)this.entries.get(name);
    }

    public Integer getInteger(String name) {
        return (Integer)this.entries.get(name);
    }

    public <E> List<? extends E> getList(String name, Class<E> elementType) {
        List entry = (List)this.entries.get(name);
        int len = entry != null ? entry.size() : 0;
        for (int i = 0; i < len; ++i) {
            Object obj = entry.get(i);
            if (elementType.isInstance(obj)) continue;
            throw new ClassCastException("Cannot cast " + obj + "with class " + obj.getClass().getName() + " to class " + elementType.getName());
        }
        return entry;
    }

    public <E> E[] getArray(String name, Class<E> elementType) {
        List entry = (List)this.entries.get(name);
        if (entry == null) {
            return (Object[])Array.newInstance(elementType, 0);
        }
        int len = entry.size();
        Object array = Array.newInstance(elementType, len);
        for (int i = 0; i < len; ++i) {
            Object obj = entry.get(i);
            if (!elementType.isInstance(obj)) {
                throw new ClassCastException("Cannot cast " + obj + "with class " + obj.getClass().getName() + " to class " + elementType.getName());
            }
            Array.set(array, i, obj);
        }
        return (Object[])array;
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.entries.get(name);
    }

    public JSON getJSON(String name) {
        return (JSON)this.entries.get(name);
    }

    public boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    public JSON clear() {
        this.entries.clear();
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JSON) {
            JSON that = (JSON)obj;
            return this.entries.equals(that.entries);
        }
        return false;
    }

    public <E> JSON merge(JSON json) {
        return this.merge(json.entries);
    }

    public <E> JSON merge(Map<String, E> map) {
        for (Map.Entry<String, E> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <E> JSON map(String name, Map<String, E> map) {
        return this.set(name, map);
    }

    public JSON list(String name) {
        return this.set(name, EMPTY_STRING_ARRAY);
    }

    public <E> JSON list(String name, E ... elements) {
        return this.set(name, elements);
    }

    public <E> JSON map(String name, Iterable<E> elements) {
        return this.set(name, elements);
    }

    public JSON set(String name, Object o) {
        this.entries.put(name, JSON.unwrap(o));
        return this;
    }

    public TreeMap<String, Object> build() {
        TreeMap<String, Object> ret = new TreeMap<String, Object>((SortedMap<String, Object>)this.entries);
        for (Map.Entry<String, Object> entry : ret.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof JSON)) continue;
            JSON json = (JSON)value;
            entry.setValue(json.build());
        }
        return ret;
    }

    private static Object unwrap(Object o) {
        Class<?> type;
        if (o != null && !(o instanceof JSON) && !simpleTypes.contains(type = o.getClass())) {
            if (o instanceof Map) {
                Map map = (Map)o;
                JSON json = new JSON();
                for (Map.Entry entry : map.entrySet()) {
                    String name = entry.getKey().toString();
                    Object value = JSON.unwrap(entry.getValue());
                    json.entries.put(name, value);
                }
                o = json;
            } else if (o instanceof Iterable) {
                ArrayList<Object> r = new ArrayList<Object>();
                for (Object element : (Iterable)o) {
                    Object unwrapped = JSON.unwrap(element);
                    r.add(unwrapped);
                }
                o = r;
            } else if (o.getClass().isArray()) {
                int length = Array.getLength(o);
                ArrayList<Object> r = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    Object component = Array.get(o, i);
                    Object unwrapped = JSON.unwrap(component);
                    r.add(unwrapped);
                }
                o = r;
            } else {
                Object json;
                block17: {
                    json = null;
                    try {
                        Method toJSON = type.getMethod("toJSON", new Class[0]);
                        if (toJSON.getReturnType() == Void.TYPE) break block17;
                        try {
                            json = toJSON.invoke(o, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable t = e.getCause();
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (t instanceof Error) {
                                throw (Error)t;
                            }
                            throw new UndeclaredThrowableException(t);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                o = json != null ? JSON.unwrap(json) : o.toString();
            }
        }
        return o;
    }

    public <A extends Appendable> A toString(A appendable) throws IOException {
        return JSON.toString(this, appendable);
    }

    public <A extends Appendable> A toString(A appendable, int indent) throws IOException {
        return JSON.toString(this, appendable, indent);
    }

    public String toString() {
        try {
            return this.toString(new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static <A extends Appendable> A toString(Object o, A appendable) throws IOException {
        return JSON.toString(o, appendable, 0);
    }

    public static <A extends Appendable> A toString(Object o, A appendable, int indent) throws IOException {
        return JSON.toString(o, appendable, 0, indent);
    }

    private static <A extends Appendable> A toString(Object o, A appendable, int margin, int indent) throws IOException {
        if (o == null) {
            appendable.append("null");
        } else if (o instanceof JSON) {
            JSON m = (JSON)o;
            appendable.append('{');
            Iterator<Map.Entry<String, Object>> iterator = m.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                if (indent > 0) {
                    appendable.append('\n');
                    JSON.pad(appendable, margin + indent);
                }
                appendable.append('\"');
                appendable.append(entry.getKey().toString());
                appendable.append("\":");
                JSON.toString(entry.getValue(), appendable, margin + indent, indent);
                if (iterator.hasNext()) {
                    appendable.append(',');
                    continue;
                }
                if (indent <= 0) continue;
                appendable.append('\n');
                JSON.pad(appendable, margin);
            }
            appendable.append('}');
        } else if (o instanceof List) {
            appendable.append('[');
            List list = (List)o;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object e = i.next();
                JSON.toString(e, appendable, margin + indent, indent);
                if (!i.hasNext()) continue;
                appendable.append(',');
            }
            appendable.append("]");
        } else if (o instanceof Boolean || o instanceof Number) {
            appendable.append(o.toString());
        } else {
            appendable.append('\"');
            CharSequence s = o instanceof CharSequence ? (CharSequence)o : o.toString();
            int len = s.length();
            block10: for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        appendable.append("\\\"");
                        continue block10;
                    }
                    case '\n': {
                        appendable.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        appendable.append("\\r");
                        continue block10;
                    }
                    case '\b': {
                        appendable.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        appendable.append("\\f");
                        continue block10;
                    }
                    case '\t': {
                        appendable.append("\\t");
                        continue block10;
                    }
                    default: {
                        appendable.append(c);
                    }
                }
            }
            appendable.append('\"');
        }
        return appendable;
    }

    private static void pad(Appendable appendable, int size) throws IOException {
        while (size-- > 0) {
            appendable.append(' ');
        }
    }

    public static Object parse(String json) {
        JSONParser parser = new JSONParser(new StringReader(json));
        try {
            return parser.parse();
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }
}

