/*
 * Decompiled with CFR 0.152.
 */
package juzu.request;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import juzu.Consumes;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.io.Encoding;
import juzu.io.UndeclaredIOException;
import juzu.request.Dispatch;
import juzu.request.ResponseParameter;

public abstract class Phase
implements Serializable {
    public static final Action ACTION = new Action();
    public static final Event EVENT = new Event();
    public static final View VIEW = new View();
    public static final Resource RESOURCE = new Resource();
    private static final List<Phase> values = Collections.unmodifiableList(Arrays.asList(ACTION, EVENT, VIEW, RESOURCE));
    public final Class<? extends Annotation> annotation;

    protected final Object readResolve() {
        if (this instanceof Action) {
            return ACTION;
        }
        if (this instanceof View) {
            return VIEW;
        }
        if (this instanceof Resource) {
            return RESOURCE;
        }
        if (this instanceof Event) {
            return EVENT;
        }
        return this;
    }

    public static List<Phase> values() {
        return values;
    }

    public static Phase valueOf(String s) {
        if ("ACTION".equals(s)) {
            return ACTION;
        }
        if ("VIEW".equals(s)) {
            return VIEW;
        }
        if ("RESOURCE".equals(s)) {
            return RESOURCE;
        }
        if ("EVENT".equals(s)) {
            return EVENT;
        }
        return null;
    }

    Phase(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public abstract String name();

    public abstract String id(Annotation var1) throws ClassCastException;

    private static class AbstractDispatch
    implements Dispatch {
        private PropertyMap properties = null;
        private MimeType mimeType = null;
        private final DispatchBridge bridge;

        private AbstractDispatch(DispatchBridge bridge) {
            this.bridge = bridge;
        }

        @Override
        public Dispatch with(MimeType mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public Dispatch with(PropertyMap properties) {
            this.properties = new PropertyMap(properties);
            return this;
        }

        @Override
        public Dispatch escapeXML(Boolean escapeXML) {
            this.setProperty(PropertyType.ESCAPE_XML, escapeXML);
            return this;
        }

        @Override
        public Dispatch setParameter(String name, String value) throws NullPointerException {
            ResponseParameter.create(name, value).addTo(this.bridge.getParameters());
            return this;
        }

        @Override
        public Dispatch setParameter(Encoding encoding, String name, String value) throws NullPointerException {
            ResponseParameter.create(encoding, name, value).addTo(this.bridge.getParameters());
            return this;
        }

        @Override
        public Dispatch setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
            ResponseParameter.create(name, value).addTo(this.bridge.getParameters());
            return this;
        }

        @Override
        public Dispatch setParameter(Encoding encoding, String name, String[] value) throws NullPointerException {
            ResponseParameter.create(encoding, name, value).addTo(this.bridge.getParameters());
            return this;
        }

        @Override
        public <T> Dispatch setProperty(PropertyType<T> propertyType, T propertyValue) throws IllegalArgumentException {
            String invalid = this.bridge.checkPropertyValidity(propertyType, propertyValue);
            if (invalid != null) {
                throw new IllegalArgumentException(invalid);
            }
            if (this.properties == null) {
                this.properties = new PropertyMap();
            }
            this.properties.setValue(propertyType, propertyValue);
            return this;
        }

        public Map<String, ResponseParameter> getParameters() {
            return this.bridge.getParameters();
        }

        @Override
        public String toString() {
            try {
                StringBuilder builder = new StringBuilder();
                this.bridge.renderURL(this.properties, this.mimeType, builder);
                return builder.toString();
            }
            catch (IOException e) {
                throw new UndeclaredIOException(e);
            }
        }
    }

    public static final class Resource
    extends Phase {
        public Resource() {
            super(juzu.Resource.class);
        }

        @Override
        public String name() {
            return "RESOURCE";
        }

        @Override
        public String id(Annotation annotation) throws ClassCastException {
            return ((juzu.Resource)annotation).id();
        }

        public static class Dispatch
        implements juzu.request.Dispatch {
            private final AbstractDispatch delegate;

            public Dispatch(DispatchBridge delegate) {
                this.delegate = new AbstractDispatch(delegate);
            }

            @Override
            public final juzu.request.Dispatch with(MimeType mimeType) {
                this.delegate.with(mimeType);
                return this;
            }

            @Override
            public final juzu.request.Dispatch with(PropertyMap properties) {
                this.delegate.with(properties);
                return this;
            }

            @Override
            public final juzu.request.Dispatch escapeXML(Boolean escapeXML) {
                this.delegate.escapeXML(escapeXML);
                return this;
            }

            @Override
            public final <T> juzu.request.Dispatch setProperty(PropertyType<T> propertyType, T propertyValue) throws IllegalArgumentException {
                this.delegate.setProperty(propertyType, propertyValue);
                return this;
            }

            @Override
            public final Dispatch setParameter(String name, String value) throws NullPointerException {
                this.delegate.setParameter(name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(Encoding encoding, String name, String value) throws NullPointerException {
                this.delegate.setParameter(encoding, name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
                this.delegate.setParameter(name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(Encoding encoding, String name, String[] value) throws NullPointerException {
                this.delegate.setParameter(encoding, name, value);
                return this;
            }

            @Override
            public final String toString() {
                return this.delegate.toString();
            }
        }
    }

    public static final class View
    extends Phase {
        public View() {
            super(juzu.View.class);
        }

        @Override
        public String name() {
            return "VIEW";
        }

        @Override
        public String id(Annotation annotation) throws ClassCastException {
            return ((juzu.View)annotation).id();
        }

        public static class Dispatch
        extends Response.View
        implements juzu.request.Dispatch {
            private final AbstractDispatch delegate;

            public Dispatch(DispatchBridge delegate) {
                this.delegate = new AbstractDispatch(delegate);
            }

            @Override
            public juzu.request.Dispatch with(MimeType mimeType) {
                this.delegate.with(mimeType);
                return this;
            }

            @Override
            public juzu.request.Dispatch with(PropertyMap properties) {
                this.delegate.with(properties);
                return this;
            }

            @Override
            public juzu.request.Dispatch escapeXML(Boolean escapeXML) {
                this.delegate.escapeXML(escapeXML);
                return this;
            }

            @Override
            public <T> juzu.request.Dispatch setProperty(PropertyType<T> propertyType, T propertyValue) throws IllegalArgumentException {
                this.delegate.setProperty(propertyType, propertyValue);
                return this;
            }

            public Map<String, ResponseParameter> getParameters() {
                return this.delegate.getParameters();
            }

            public MethodHandle getTarget() {
                return this.delegate.bridge.getTarget();
            }

            @Override
            public final Dispatch setParameter(String name, String value) throws NullPointerException {
                this.delegate.setParameter(name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(Encoding encoding, String name, String value) throws NullPointerException {
                this.delegate.setParameter(encoding, name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
                this.delegate.setParameter(name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(Encoding encoding, String name, String[] value) throws NullPointerException {
                this.delegate.setParameter(encoding, name, value);
                return this;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Dispatch) {
                    Dispatch that = (Dispatch)obj;
                    return ((Object)this.getParameters()).equals(that.getParameters()) && this.properties.equals(that.properties);
                }
                return false;
            }

            @Override
            public final String toString() {
                return this.delegate.toString();
            }
        }
    }

    public static final class Event
    extends Phase {
        public Event() {
            super(Consumes.class);
        }

        @Override
        public String name() {
            return "EVENT";
        }

        @Override
        public String id(Annotation annotation) throws ClassCastException {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Action
    extends Phase {
        public Action() {
            super(juzu.Action.class);
        }

        @Override
        public String name() {
            return "ACTION";
        }

        @Override
        public String id(Annotation annotation) throws ClassCastException {
            return ((juzu.Action)annotation).id();
        }

        public static class Dispatch
        implements juzu.request.Dispatch {
            private final AbstractDispatch delegate;

            public Dispatch(DispatchBridge delegate) {
                this.delegate = new AbstractDispatch(delegate);
            }

            @Override
            public juzu.request.Dispatch with(MimeType mimeType) {
                this.delegate.with(mimeType);
                return this;
            }

            @Override
            public juzu.request.Dispatch with(PropertyMap properties) {
                this.delegate.with(properties);
                return this;
            }

            @Override
            public juzu.request.Dispatch escapeXML(Boolean escapeXML) {
                this.delegate.escapeXML(escapeXML);
                return this;
            }

            @Override
            public <T> juzu.request.Dispatch setProperty(PropertyType<T> propertyType, T propertyValue) throws IllegalArgumentException {
                this.delegate.setProperty(propertyType, propertyValue);
                return this;
            }

            @Override
            public final Dispatch setParameter(String name, String value) throws NullPointerException {
                this.delegate.setParameter(name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(Encoding encoding, String name, String value) throws NullPointerException {
                this.delegate.setParameter(encoding, name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
                this.delegate.setParameter(name, value);
                return this;
            }

            @Override
            public final Dispatch setParameter(Encoding encoding, String name, String[] value) throws NullPointerException {
                this.delegate.setParameter(encoding, name, value);
                return this;
            }

            @Override
            public String toString() {
                return this.delegate.toString();
            }
        }
    }
}

