/* Generated By:JavaCC: Do not edit this line. JSONParser.java */
package juzu.impl.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

// Based on https://github.com/mwnorman/JSONParser
// at https://github.com/mwnorman/JSONParser/tree/90baa1b93e5779e4aff771bd1d9aa12578fbad0a
// with very few modifications

public class JSONParser implements JSONParserConstants {

  final public Object parse() throws ParseException {
Object o = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENBRACE:
      o = object();
      break;
    case O_OPENBRACKET:
      o = array();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return o;}
    throw new Error("Missing return statement in function");
  }

  final public JSON object() throws ParseException {
JSON m = JSON.json();
    jj_consume_token(O_OPENBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_QUOTED_STRING:
    case QUOTED_STRING:
    case UNQUOTED_STRING:
      members(m);
      break;
    default:
      ;
    }
    jj_consume_token(O_CLOSEBRACE);
        {if (true) return m;}
    throw new Error("Missing return statement in function");
  }

  final public void members(JSON m) throws ParseException {
    pair(m);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      members(m);
      break;
    default:
      ;
    }
  }

  final public void pair(JSON m) throws ParseException {
Token t = null;
Object o;
String fieldName = null;
    fieldName = fieldName();
    jj_consume_token(O_COLON);
    o = value();
        m.set(fieldName, o);
  }

  final public String fieldName() throws ParseException {
String fieldName = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_QUOTED_STRING:
      jj_consume_token(SINGLE_QUOTED_STRING);
          fieldName = stripOffQuotes(decodeBackslash(token.image));
      break;
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
          fieldName = stripOffQuotes(decodeBackslash(token.image));
      break;
    case UNQUOTED_STRING:
      jj_consume_token(UNQUOTED_STRING);
          fieldName = decodeBackslash(token.image);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return fieldName;}
    throw new Error("Missing return statement in function");
  }

  String stripOffQuotes(String quotedString) throws ParseException {
    if (!(quotedString.startsWith("\u005c"") || quotedString.startsWith("'"))) {
        return quotedString;
    }
    return quotedString.substring(1, quotedString.length() - 1);
  }

  String decodeBackslash(String s) throws ParseException {
    StringBuilder sb = new StringBuilder();
    int inputLength = s.length();
    boolean isAfterSlash = false;
    for (int i = 0; i < inputLength; i ++) {
        char c = s.charAt(i);
        if (c == '\u005c\u005c') {
            if (!isAfterSlash) {
                isAfterSlash = true;
            }
            else {
                sb.append(c);
                isAfterSlash = false;
            }
        }
        else {
            if (isAfterSlash) {
                switch (c) {
                    case 'n':
                        sb.append('\u005cn');
                    break;
                    case 'r':
                        sb.append('\u005cr');
                    break;
                    case 't':
                        sb.append('\u005ct');
                    break;
                    case 'b':
                        sb.append('\u005cb');
                    break;
                    case 'f':
                        sb.append('\u005cf');
                    break;
                    case '\u005c'':
                        sb.append('\u005c'');
                    break;
                    case '/':
                        sb.append('/');
                    break;
                    case '\u005c"':
                        sb.append('\u005c"');
                    break;
                    //handle Unicode-escaping
                    case 'u':
                        int u = Integer.parseInt(s.substring(i + 1, i + 5), 16);
                        sb.append((char)u);
                        i += 4;
                    break;
                }
                isAfterSlash = false;
            }
            else {
                sb.append(c);
            }
        }
    }
    return sb.toString();
  }

  final public ArrayList<Object> array() throws ParseException {
ArrayList<Object> a=new ArrayList<Object>();
    jj_consume_token(O_OPENBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_TRUE:
    case K_FALSE:
    case K_NULL:
    case O_OPENBRACE:
    case O_OPENBRACKET:
    case NUMBER:
    case SINGLE_QUOTED_STRING:
    case QUOTED_STRING:
      elements(a);
      break;
    default:
      ;
    }
    jj_consume_token(O_CLOSEBRACKET);
        Collections.reverse(a);
        {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

  final public void elements(List<Object> a) throws ParseException {
Object o = null;
    o = value();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      elements(a);
      break;
    default:
      ;
    }
        a.add(o);
  }

  final public Object value() throws ParseException {
Token t = null;
Object o = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENBRACE:
      o = object();
      break;
    case O_OPENBRACKET:
      o = array();
      break;
    case SINGLE_QUOTED_STRING:
      t = jj_consume_token(SINGLE_QUOTED_STRING);
                                  o = stripOffQuotes(decodeBackslash(t.image));
      break;
    case QUOTED_STRING:
      t = jj_consume_token(QUOTED_STRING);
                           o = stripOffQuotes(decodeBackslash(t.image));
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
            try {
              o = Integer.valueOf(t.image);

            }
            catch (NumberFormatException nfe1) {
                try {
                    o = Long.valueOf(t.image);
                }
                catch (NumberFormatException nfe2) {
                    try {
                        o = Float.valueOf(t.image);
                    }
                    catch (NumberFormatException nfe3) {
                        try {
                            o = Double.valueOf(t.image);
                        }
                        catch  (NumberFormatException nfe4) {
                            o = Double.NaN;
                        }
                    }
                }

            }
      break;
    case K_TRUE:
      jj_consume_token(K_TRUE);
                  o = Boolean.TRUE;
      break;
    case K_FALSE:
      jj_consume_token(K_FALSE);
                   o = Boolean.FALSE;
      break;
    case K_NULL:
      jj_consume_token(K_NULL);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return o;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public JSONParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;

  /** Constructor with InputStream. */
  public JSONParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public JSONParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new JSONParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Constructor. */
  public JSONParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new JSONParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Constructor with generated Token Manager. */
  public JSONParser(JSONParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(JSONParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      return token;
    }
    token = oldToken;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    Token errortok = token.next;
    int line = errortok.beginLine, column = errortok.beginColumn;
    String mess = (errortok.kind == 0) ? tokenImage[0] : errortok.image;
    return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
