/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import juzu.impl.common.Logger;
import juzu.impl.common.RunMode;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.resource.ResourceResolver;

public abstract class BridgeContext {
    private RunMode runMode;

    public RunMode getRunMode() {
        if (this.runMode == null) {
            String runModeValue = this.getInitParameter("juzu.run_mode");
            if (runModeValue != null) {
                runModeValue = Tools.interpolate(runModeValue, System.getProperties());
                this.runMode = RunMode.parse(runModeValue);
                if (this.runMode == null) {
                    this.runMode = RunMode.PROD;
                }
            } else {
                this.runMode = RunMode.PROD;
            }
        }
        return this.runMode;
    }

    public abstract Logger getLogger(String var1);

    public abstract ReadFileSystem<?> getClassPath();

    public abstract ReadFileSystem<?> getSourcePath();

    public abstract ReadFileSystem<?> getResourcePath();

    public abstract ClassLoader getClassLoader();

    public abstract String getInitParameter(String var1);

    public abstract ResourceResolver getResolver();

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);
}

