/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import juzu.impl.router.regex.Literal;

class PatternBuilder {
    private final StringBuilder buffer = new StringBuilder();

    PatternBuilder() {
    }

    public PatternBuilder expr(CharSequence s) {
        if (s == null) {
            throw new NullPointerException("No null expression allowed");
        }
        this.buffer.append(s);
        return this;
    }

    public PatternBuilder expr(char s) {
        this.buffer.append(s);
        return this;
    }

    public PatternBuilder litteral(CharSequence s, int from, int to) {
        if (from < 0) {
            throw new IllegalArgumentException("No negative from argument");
        }
        if (to > s.length()) {
            throw new IllegalArgumentException("No to argument greater than the string length");
        }
        if (from > to) {
            throw new IllegalArgumentException("The to argument cannot be greater than the from argument");
        }
        if (from < to) {
            for (int i = from; i < to; ++i) {
                char c = s.charAt(i);
                if (Literal.isEscaped(c)) {
                    this.buffer.append('\\');
                }
                this.buffer.append(c);
            }
        }
        return this;
    }

    public PatternBuilder literal(CharSequence s, int from) {
        return this.litteral(s, from, s.length());
    }

    public PatternBuilder literal(CharSequence s) {
        return this.litteral(s, 0, s.length());
    }

    public PatternBuilder literal(char c) {
        return this.literal(Character.toString(c));
    }

    public PatternBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public String build() {
        return this.buffer.toString();
    }
}

