/*
 * Decompiled with CFR 0.152.
 */
package examples.plugin.bundlegen.impl;

import examples.plugin.bundlegen.BundleGen;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;

public class BundleGenMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode BUNDLE_NOT_FOUND = new MessageCode("BUNDLE_NOT_FOUND", "The bundle %1$s cannot be resolved");
    public static final MessageCode CANNOT_CREATE_BUNDLE = new MessageCode("CANNOT_CREATE_BUNDLE", "The bundle %1$s cannot be created");
    private HashMap<ElementHandle.Package, String> bundles = new HashMap();

    public BundleGenMetaModelPlugin() {
        super("bundlegen");
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(BundleGen.class);
    }

    public void processAnnotationAdded(ApplicationMetaModel application, AnnotationKey key, AnnotationState added) {
        Name type = key.getType();
        if (type.toString().equals(BundleGen.class.getName())) {
            ElementHandle.Package pkg = (ElementHandle.Package)key.getElement();
            this.bundles.put(pkg, (String)added.get((Object)"value"));
        }
    }

    public void processAnnotationRemoved(ApplicationMetaModel application, AnnotationKey key, AnnotationState removed) {
        Name type = key.getType();
        if (type.toString().equals(BundleGen.class.getName())) {
            ElementHandle.Package pkg = (ElementHandle.Package)key.getElement();
            this.bundles.remove(pkg);
        }
    }

    public void prePassivate(ApplicationMetaModel application) {
        for (Map.Entry<ElementHandle.Package, String> entry : this.bundles.entrySet()) {
            ElementHandle.Package pkg = entry.getKey();
            String bundleName = entry.getValue();
            this.processBundle(application, pkg, bundleName);
        }
    }

    private void processBundle(ApplicationMetaModel application, ElementHandle.Package pkg, String bundleName) {
        ProcessingContext context = application.getProcessingContext();
        PackageElement pkgElt = (PackageElement)context.get((ElementHandle)pkg);
        Properties properties = this.loadBundle(context, pkg, bundleName);
        if (properties == null) {
            throw BUNDLE_NOT_FOUND.failure((Element)pkgElt, new Object[]{bundleName});
        }
        try {
            this.generateBundleClass(context, properties, pkgElt, bundleName);
        }
        catch (IOException e) {
            throw CANNOT_CREATE_BUNDLE.failure((Element)pkgElt, new Object[]{bundleName}).initCause((Throwable)e);
        }
    }

    private Properties loadBundle(ProcessingContext context, ElementHandle.Package pkg, String bundleName) {
        Path.Absolute absolute = pkg.getPackageName().resolve(bundleName + ".properties");
        FileObject bundle = context.resolveResourceFromSourcePath(pkg, absolute);
        if (bundle != null) {
            try {
                InputStream in = bundle.openInputStream();
                Properties properties = new Properties();
                properties.load(in);
                return properties;
            }
            catch (IOException e) {
                context.log(Level.SEVERE, (CharSequence)"Could not load resource bundle", (Throwable)e);
            }
        }
        return null;
    }

    private void generateBundleClass(ProcessingContext context, Properties properties, PackageElement pkgElt, String bundleName) throws IOException {
        String fqn = pkgElt.getQualifiedName() + "." + bundleName;
        JavaFileObject source = context.createSourceFile((CharSequence)fqn, new Element[]{pkgElt});
        PrintWriter writer = new PrintWriter(source.openWriter());
        writer.println("package " + pkgElt.getQualifiedName() + ";");
        writer.println("import examples.plugin.bundlegen.impl.BundleResolver;");
        writer.println("public class " + bundleName + " {");
        for (String key : properties.stringPropertyNames()) {
            writer.println("public static String " + key + "() {");
            writer.println("return BundleResolver.resolve(" + bundleName + ".class, \"" + key + "\");");
            writer.println("}");
        }
        writer.println("}");
        writer.close();
    }
}

