/*
 * Decompiled with CFR 0.152.
 */
package examples.plugin.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import juzu.Response;
import juzu.Scope;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.plugin.ServiceContext;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.ApplicationService;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;

public class MetricsService
extends ApplicationService
implements RequestFilter<Stage.Invoke> {
    private final MetricRegistry registry = new MetricRegistry();
    private final Timer responses = this.registry.timer("juzu.responses");

    public MetricsService() {
        super("metrics");
    }

    public ServiceDescriptor init(ServiceContext context) throws Exception {
        Provider<MetricRegistry> registryProvider = new Provider<MetricRegistry>(){

            public MetricRegistry get() {
                return MetricsService.this.registry;
            }
        };
        BeanDescriptor registryDescriptor = BeanDescriptor.createFromProvider(MetricRegistry.class, (Scope)Scope.SINGLETON, Collections.emptyList(), (Provider)registryProvider);
        return new ServiceDescriptor(Arrays.asList(registryDescriptor));
    }

    @PostConstruct
    public void start() {
        SharedMetricRegistries.add((String)this.application.getPackageName(), (MetricRegistry)this.registry);
    }

    @PreDestroy
    public void stop() {
        SharedMetricRegistries.remove((String)this.application.getPackageName());
    }

    public Class<Stage.Invoke> getStageType() {
        return Stage.Invoke.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Stage.Invoke argument) {
        Timer.Context context = this.responses.time();
        try {
            Response response = argument.invoke();
            return response;
        }
        finally {
            context.stop();
        }
    }
}

