/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.tutorial.juzcret.step7;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import juzu.Action;
import juzu.Mapped;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.plugin.ajax.Ajax;
import juzu.plugin.validation.ValidationError;
import juzu.request.RequestContext;
import juzu.request.RequestLifeCycle;
import juzu.request.SecurityContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.juzu.tutorial.juzcret.step7.JuZcretApplication_;
import org.juzu.tutorial.juzcret.step7.models.Comment;
import org.juzu.tutorial.juzcret.step7.services.SecretService;
import org.juzu.tutorial.juzcret.step7.templates.addSecret;
import org.juzu.tutorial.juzcret.step7.templates.editMode;
import org.juzu.tutorial.juzcret.step7.templates.secretWall;

public class JuZcretApplication
implements RequestLifeCycle {
    @Inject
    PortletPreferences prefs;
    @Inject
    SecretService secretService;
    @Inject
    @Path(value="secretWall.gtmpl")
    secretWall secretWall;
    @Inject
    @Path(value="addSecret.gtmpl")
    addSecret addSecret;
    @Inject
    @Path(value="editMode.gtmpl")
    editMode editMode;
    public static final String ENABLE_COMMENT = "enableComment";
    private static final String ANONYMOUS = "Anonymous";

    @View
    public Response.Content index(RequestContext context) {
        boolean enableComment = Boolean.parseBoolean(this.prefs.getValue(ENABLE_COMMENT, "true"));
        if (PortletMode.EDIT.equals(context.getProperty(JuzuPortlet.PORTLET_MODE))) {
            return this.editMode.with().enableComment((Object)enableComment).ok();
        }
        return this.secretWall.with().enableComment((Object)enableComment).secretsList((Object)this.secretService.getSecrets()).ok();
    }

    @View
    public Response.Content addSecretForm() {
        return this.addSecret.ok();
    }

    @Ajax
    @Resource
    public Response addComment(String secretId, @Mapped @Valid Comment comment, SecurityContext context) {
        comment.setUserId(this.getCurrentUser(context));
        Comment result = this.secretService.addComment(secretId, comment);
        if (result != null) {
            return Response.ok((CharSequence)new JSONObject((Object)result).toString()).withMimeType("text/json");
        }
        return Response.status((int)503);
    }

    @Ajax
    @Resource
    public Response addLike(String secretId, SecurityContext context) {
        Set likes = this.secretService.addLike(secretId, this.getCurrentUser(context));
        if (likes != null) {
            return Response.ok((CharSequence)new JSONArray((Collection)likes).toString()).withMimeType("text/json");
        }
        return Response.status((int)503);
    }

    @Action
    public Response.View addSecret(String msg, String imgURL) {
        this.secretService.addSecret(msg, imgURL);
        return JuZcretApplication_.index();
    }

    @Action
    public Response.View enableComment(String enableComment) throws ReadOnlyException, ValidatorException, IOException {
        if ("on".equals(enableComment)) {
            enableComment = "true";
        }
        this.prefs.setValue(ENABLE_COMMENT, enableComment);
        this.prefs.store();
        return JuZcretApplication_.index().with(JuzuPortlet.PORTLET_MODE, (Object)PortletMode.VIEW);
    }

    public void endRequest(RequestContext context) {
        Response response = context.getResponse();
        if (response instanceof ValidationError) {
            ValidationError error = (ValidationError)response;
            Set violations = error.getViolations();
            String msg = ((ConstraintViolation)violations.iterator().next()).getMessage();
            response = Response.ok((CharSequence)msg).withMimeType("text/html");
            context.setResponse(response);
        }
    }

    public void beginRequest(RequestContext context) {
    }

    private String getCurrentUser(SecurityContext context) {
        Principal user = context.getUserPrincipal();
        if (user == null) {
            return ANONYMOUS;
        }
        return user.getName();
    }
}

