/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.closurecompiler;

import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import juzu.plugin.asset.Minifier;

public class ClosureMinifier
implements Minifier {
    public InputStream minify(String name, String type, InputStream stream) throws IOException {
        if (type.equals("script")) {
            Compiler compiler = new Compiler();
            CompilerOptions options = new CompilerOptions();
            SourceFile source = SourceFile.fromInputStream((String)name, (InputStream)stream);
            Result result = compiler.compile(Collections.emptyList(), Collections.singletonList(source), options);
            if (result.errors.length > 0) {
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                writer.println("Malformed asset:");
                for (JSError error : result.errors) {
                    writer.println(error);
                }
                throw new IOException(buffer.toString());
            }
            String s = compiler.toSource();
            return new ByteArrayInputStream(s.getBytes());
        }
        throw new IOException("Can only process scripts and not " + type + " asset");
    }
}

