/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.less.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.FileKey;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.Message;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModelPlugin;
import juzu.plugin.less.Less;
import juzu.plugin.less.impl.CompilerLessContext;
import juzu.plugin.less.impl.lesser.Compilation;
import juzu.plugin.less.impl.lesser.Failure;
import juzu.plugin.less.impl.lesser.JSContext;
import juzu.plugin.less.impl.lesser.LessError;
import juzu.plugin.less.impl.lesser.Lesser;
import juzu.plugin.less.impl.lesser.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessMetaModelPlugin
extends ModuleMetaModelPlugin {
    public static final MessageCode COMPILATION_ERROR = new MessageCode("LESS_COMPILATION_ERROR", "%1$s in %2$s on line %3$s, column %4$s:\n%5$s");
    public static final MessageCode MALFORMED_PATH = new MessageCode("LESS_MALFORMED_PATH", "The resource path %1$s is malformed");
    private static final Name LESS = Name.create(Less.class);
    static final Logger log = BaseProcessor.getLogger(LessMetaModelPlugin.class);
    private HashMap<Name, AnnotationState> annotations;

    public LessMetaModelPlugin() {
        super("less");
    }

    public void init(ModuleMetaModel metaModel) {
        this.annotations = new HashMap();
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Less.class);
    }

    public void processAnnotationChange(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState removed, AnnotationState added) {
        if (key.getType().equals((Object)LESS)) {
            Name pkg = key.getElement().getPackage();
            log.log((CharSequence)("Recording less annotation for package " + pkg));
            this.annotations.put(pkg, added);
        }
    }

    public void postActivate(ModuleMetaModel metaModel) {
        this.annotations = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePassivate(ModuleMetaModel metaModel) {
        HashMap<Name, AnnotationState> clone = this.annotations;
        this.annotations = null;
        for (Map.Entry<Name, AnnotationState> entry : clone.entrySet()) {
            AnnotationState annotation = entry.getValue();
            Name pkg = entry.getKey();
            ProcessingContext env = metaModel.processingContext;
            ElementHandle.Package pkgHandle = ElementHandle.Package.create((Name)pkg);
            PackageElement pkgElt = (PackageElement)env.get((ElementHandle)pkgHandle);
            Boolean minify = (Boolean)annotation.get((Object)"minify");
            List resources = (List)annotation.get((Object)"value");
            AnnotationMirror annotationMirror = Tools.getAnnotation((Element)pkgElt, (String)Less.class.getName());
            log.log((CharSequence)("Handling less annotation for package " + pkg + ": minify=" + minify + " resources=" + resources));
            if (resources == null || resources.size() <= 0) continue;
            Name assetPkg = pkg.append(new String[]{"assets"});
            CompilerLessContext clc = new CompilerLessContext(env, pkgHandle, assetPkg);
            for (String resource : resources) {
                Result result;
                Path path;
                log.log((CharSequence)("Processing declared resource " + resource));
                try {
                    path = Path.parse((String)resource);
                }
                catch (IllegalArgumentException e) {
                    throw MALFORMED_PATH.failure((Element)pkgElt, annotationMirror, new Object[]{resource}).initCause((Throwable)e);
                }
                FileKey to = assetPkg.resolve(path.as("css"));
                log.log((CharSequence)("Resource " + resource + " destination resolved to " + to));
                try {
                    Lesser lesser = new Lesser(JSContext.create());
                    result = lesser.compile(clc, resource, Boolean.TRUE.equals(minify));
                }
                catch (Exception e) {
                    log.log((CharSequence)"Unexpected exception", (Throwable)e);
                    throw new UnsupportedOperationException(e);
                }
                if (result instanceof Compilation) {
                    try {
                        log.log((CharSequence)("Resource " + resource + " compiled about to write on disk as " + to));
                        Compilation compilation = (Compilation)result;
                        FileObject fo = env.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, to, new Element[0]);
                        Writer writer = fo.openWriter();
                        try {
                            writer.write(compilation.getValue());
                        }
                        finally {
                            Tools.safeClose((Closeable)writer);
                        }
                    }
                    catch (IOException e) {
                        log.log((CharSequence)("Resource " + to + " could not be written on disk"), (Throwable)e);
                    }
                    continue;
                }
                Failure failure = (Failure)result;
                LinkedList<LessError> errors = failure.getErrors();
                ArrayList<Message> messages = new ArrayList<Message>(errors.size());
                StringBuilder sb = new StringBuilder();
                for (LessError error : errors) {
                    String text = error.message != null ? error.message : "There is an error in your .less file";
                    int index = error.line - (error.extract.length - 1) / 2;
                    for (String line : error.extract) {
                        sb.append("[").append(index).append("]");
                        sb.append(index == error.line ? " -> " : "    ");
                        sb.append(line).append("\n");
                        ++index;
                    }
                    Message msg = new Message(COMPILATION_ERROR, new Object[]{text, error.src, error.line, error.column + 1, sb});
                    log.log((CharSequence)msg.toDisplayString());
                    messages.add(msg);
                }
                throw new ProcessingException((Element)pkgElt, annotationMirror, messages);
            }
        }
    }
}

