/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.less4j.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.asset.AssetLocation;
import juzu.impl.common.Logger;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.asset.Asset;
import juzu.impl.plugin.asset.AssetsMetaModel;
import juzu.plugin.less4j.Less;
import juzu.plugin.less4j.impl.LessAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelPluginImpl
extends ApplicationMetaModelPlugin {
    public static final MessageCode GENERAL_PROBLEM = new MessageCode("GENERAL_PROBLEM", "%1$s:\n%2$s");
    public static final MessageCode COMPILATION_ERROR = new MessageCode("LESS_COMPILATION_ERROR", "%1$s in %2$s on line %3$s:\n%4$s");
    public static final MessageCode MALFORMED_PATH = new MessageCode("LESS_MALFORMED_PATH", "The resource path %1$s is malformed");
    static final Logger log = BaseProcessor.getLogger(MetaModelPluginImpl.class);

    public MetaModelPluginImpl() {
        super("less");
    }

    public void init(ApplicationMetaModel metaModel) {
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Less.class);
    }

    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        AssetsMetaModel assetsMetaModel = (AssetsMetaModel)metaModel.getChild(AssetsMetaModel.KEY);
        List<LessAsset> assets = this.getAssets(assetsMetaModel, added);
        for (LessAsset asset : assets) {
            assetsMetaModel.addAsset((Asset)asset);
            if (asset.resource == null) continue;
            assetsMetaModel.addResource(asset.key.value, asset.resource);
        }
    }

    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        AssetsMetaModel assetsMetaModel = (AssetsMetaModel)metaModel.getChild(AssetsMetaModel.KEY);
        List<LessAsset> assets = this.getAssets(assetsMetaModel, removed);
        for (LessAsset asset : assets) {
            assetsMetaModel.removeAsset((Asset)asset);
            if (asset.resource == null) continue;
            assetsMetaModel.removeResource(asset.key.value, asset.resource);
        }
    }

    private List<LessAsset> getAssets(AssetsMetaModel assetsMetaModel, AnnotationState annotation) {
        List<LessAsset> assets = Collections.emptyList();
        List value = (List)annotation.get((Object)"value");
        if (value != null) {
            for (AnnotationState assetAnnotation : value) {
                Serializable location;
                String assetValue = (String)assetAnnotation.get((Object)"value");
                URL resource = assetsMetaModel.resolveResource(assetValue);
                HashMap<String, String> state = new HashMap<String, String>((Map<String, String>)assetAnnotation);
                if (state.get("id") == null) {
                    state.put("id", assetValue);
                }
                if ((location = (Serializable)state.get("location")) == null) {
                    state.put("location", AssetLocation.APPLICATION.name());
                } else if (!location.equals(AssetLocation.APPLICATION.name())) {
                    throw new UnsupportedOperationException("handle me gracefully");
                }
                Asset parsed = new Asset("stylesheet", state);
                LessAsset asset = new LessAsset(parsed.id, parsed.key.value, parsed.depends, resource);
                if (assets.isEmpty()) {
                    assets = new ArrayList<LessAsset>();
                }
                assets.add(asset);
            }
        }
        return assets;
    }
}

