/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import java.util.Arrays;
import javax.inject.Provider;
import juzu.Response;
import juzu.Scope;
import juzu.impl.common.JSON;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.request.Stage;
import juzu.plugin.shiro.impl.SecurityManagerProvider;
import juzu.plugin.shiro.impl.ShiroAuthenticator;
import juzu.plugin.shiro.impl.ShiroAuthorizor;
import org.apache.shiro.mgt.SecurityManager;

public class ShiroDescriptor
extends PluginDescriptor {
    private final ShiroAuthorizor authorizer;
    private final ShiroAuthenticator authenticater;
    private final BeanDescriptor bean;
    private PluginContext context;

    ShiroDescriptor(PluginContext context) {
        JSON config = context.getConfig();
        this.authenticater = new ShiroAuthenticator(config.get("rememberMe") != null);
        this.authorizer = new ShiroAuthorizor();
        this.context = context;
        this.bean = BeanDescriptor.createFromProvider(SecurityManager.class, (Scope)Scope.SESSION, null, (Provider)new SecurityManagerProvider(config));
    }

    public JSON getConfig() {
        return this.context.getConfig();
    }

    public PluginContext getContext() {
        return this.context;
    }

    public Iterable<BeanDescriptor> getBeans() {
        return Arrays.asList(this.bean);
    }

    public Response invoke(Stage.Handler stage) {
        String methodId = stage.getRequest().getHandler().getHandle().toString();
        String controllerId = methodId.substring(0, methodId.indexOf(35));
        methodId = methodId.substring(controllerId.length() + 1);
        JSON controllerJSON = this.getConfig().getJSON(controllerId);
        if (controllerJSON == null) {
            return stage.invoke();
        }
        JSON methodsJSON = controllerJSON.getJSON("methods");
        if (controllerJSON.get("require") != null) {
            Response resp = this.authorizer.isAuthorized(stage, controllerJSON);
            if (resp != null) {
                return resp;
            }
            if (methodsJSON == null) {
                return stage.invoke();
            }
            JSON methodJSON = methodsJSON.getJSON(methodId);
            if (methodJSON == null) {
                return stage.invoke();
            }
            return this.doInvoke(stage, methodJSON);
        }
        if (methodsJSON == null) {
            return stage.invoke();
        }
        JSON methodJSON = methodsJSON.getJSON(methodId);
        if (methodJSON == null) {
            return stage.invoke();
        }
        return this.doInvoke(stage, methodJSON);
    }

    private Response doInvoke(Stage.Handler request, JSON json) {
        Response resp = this.authorizer.isAuthorized(request, json);
        if (resp != null) {
            return resp;
        }
        if ("login".equals(json.get("operator"))) {
            return this.authenticater.doLogin(request);
        }
        if ("logout".equals(json.get("operator"))) {
            return this.authenticater.doLogout(request);
        }
        return request.invoke();
    }
}

