/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import juzu.impl.bridge.spi.servlet.ServletWebBridge;
import juzu.impl.request.Request;
import juzu.request.HttpContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.io.DefaultSerializer;
import org.apache.shiro.util.ByteSource;

public class RememberMeUtil {
    private static final String DEFAULT_REMEMBER_ME_COOKIE_NAME = "rememberMe";
    private static final String DELETED_COOKIE_VALUE = "deleteMe";
    private static final int ONE_YEAR = 31536000;
    private static final long DAY_MILLIS = 86400000L;
    private static final String GMT_TIME_ZONE_ID = "GMT";
    private static final String COOKIE_DATE_FORMAT_STRING = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final String NAME_VALUE_DELIMITER = "=";
    private static final String ATTRIBUTE_DELIMITER = "; ";
    private static final String COOKIE_HEADER_NAME = "Set-Cookie";
    private static final String PATH_ATTRIBUTE_NAME = "Path";
    private static final String EXPIRES_ATTRIBUTE_NAME = "Expires";
    private static final String MAXAGE_ATTRIBUTE_NAME = "Max-Age";
    private static final String DOMAIN_ATTRIBUTE_NAME = "Domain";

    public static void rememberSerialized() {
        HttpContext context = Request.getCurrent().getHttpContext();
        if (context instanceof ServletWebBridge) {
            ServletWebBridge bridge = (ServletWebBridge)context;
            DefaultSerializer serializer = new DefaultSerializer();
            byte[] serialized = serializer.serialize((Object)SecurityUtils.getSubject().getPrincipals());
            serialized = RememberMeUtil.encrypt(serialized);
            String base64 = Base64.encodeToString((byte[])serialized);
            String name = DEFAULT_REMEMBER_ME_COOKIE_NAME;
            String value = base64;
            String domain = context.getServerName();
            String path = context.getContextPath();
            int maxAge = 31536000;
            String headerValue = RememberMeUtil.buildHeaderValue(name, value, domain.trim(), path.trim(), maxAge);
            bridge.getResponse().setHeader(COOKIE_HEADER_NAME, headerValue);
        }
    }

    public static void forgetIdentity() {
        HttpContext context = Request.getCurrent().getHttpContext();
        if (context instanceof ServletWebBridge) {
            ServletWebBridge bridge = (ServletWebBridge)context;
            String name = DEFAULT_REMEMBER_ME_COOKIE_NAME;
            String value = DELETED_COOKIE_VALUE;
            String domain = context.getServerName();
            String path = context.getContextPath();
            int maxAge = 0;
            String headerValue = RememberMeUtil.buildHeaderValue(name, value, domain.trim(), path.trim(), maxAge);
            bridge.getResponse().setHeader(COOKIE_HEADER_NAME, headerValue);
        }
    }

    private static String buildHeaderValue(String name, String value, String domain, String path, int maxAge) {
        StringBuilder sb = new StringBuilder(name).append(NAME_VALUE_DELIMITER);
        if (value != null && !value.isEmpty()) {
            sb.append(value);
        }
        if (domain != null && !domain.isEmpty()) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(DOMAIN_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(domain);
        }
        if (path != null && !path.isEmpty()) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(PATH_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(path);
        }
        if (maxAge >= 0) {
            Date expires;
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(MAXAGE_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(maxAge);
            sb.append(ATTRIBUTE_DELIMITER);
            if (maxAge == 0) {
                expires = new Date(System.currentTimeMillis() - 86400000L);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(13, maxAge);
                expires = cal.getTime();
            }
            String formatted = RememberMeUtil.toCookieDate(expires);
            sb.append(EXPIRES_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(formatted);
        }
        return sb.toString();
    }

    private static String toCookieDate(Date date) {
        TimeZone tz = TimeZone.getTimeZone(GMT_TIME_ZONE_ID);
        SimpleDateFormat fmt = new SimpleDateFormat(COOKIE_DATE_FORMAT_STRING, Locale.US);
        fmt.setTimeZone(tz);
        return fmt.format(date);
    }

    private static byte[] encrypt(byte[] serialized) {
        byte[] value = serialized;
        AesCipherService cipherService = new AesCipherService();
        if (cipherService != null) {
            ByteSource byteSource = cipherService.encrypt(serialized, Base64.decode((String)"kPH+bIxk5D2deZiIxcaaaA=="));
            value = byteSource.getBytes();
        }
        return value;
    }
}

