/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import java.util.Collection;
import java.util.List;
import juzu.Response;
import juzu.impl.common.JSON;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Request;
import juzu.impl.request.Stage;
import juzu.plugin.shiro.impl.common.ShiroTools;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;

public class ShiroAuthorizor {
    public Response isAuthorized(Stage.Handler stage, JSON json) {
        Request request = stage.getRequest();
        if (this.verify(request, json)) {
            return null;
        }
        List parameters = request.getHandler().getParameters();
        for (ControlParameter parameter : parameters) {
            if (!(parameter instanceof ContextualParameter) || !AuthorizationException.class.isAssignableFrom(parameter.getType())) continue;
            request.getContextualArguments().put((ContextualParameter)parameter, new AuthorizationException("Access denied " + request.getHandler() + " with config " + json));
            return stage.invoke();
        }
        return new Response.Error((Throwable)new AuthorizationException("Access denied " + request.getHandler() + " with config " + json));
    }

    private boolean hasRequire(Request request, JSON config) {
        Object obj = config.get("require");
        if ("guest".equals(obj)) {
            return SecurityUtils.getSubject().getPrincipal() == null;
        }
        if ("authenticate".equals(obj)) {
            return SecurityUtils.getSubject().isAuthenticated();
        }
        if ("user".equals(obj)) {
            return SecurityUtils.getSubject().getPrincipal() != null;
        }
        return false;
    }

    private boolean hasRoles(Request request, JSON config) {
        if (!SecurityUtils.getSubject().isAuthenticated()) {
            return false;
        }
        JSON foo = config.getJSON("roles");
        Logical logical = Logical.valueOf((String)foo.getString("logical"));
        List roles = (List)foo.get("value");
        if (roles.size() == 1) {
            return ShiroTools.hasRole((String)roles.get(0));
        }
        if (roles.size() > 1) {
            switch (logical) {
                case AND: {
                    return SecurityUtils.getSubject().hasAllRoles((Collection)roles);
                }
                case OR: {
                    return ShiroTools.hasRole(roles.toArray(new String[roles.size()]));
                }
            }
        }
        return false;
    }

    private boolean hasPermissions(Request request, JSON config) {
        if (!SecurityUtils.getSubject().isAuthenticated()) {
            return false;
        }
        JSON foo = config.getJSON("permissions");
        Logical logical = Logical.valueOf((String)foo.getString("logical"));
        List permissions = (List)foo.get("value");
        if (permissions.size() == 1) {
            return ShiroTools.isPermitted((String)permissions.get(0));
        }
        if (permissions.size() > 1) {
            switch (logical) {
                case AND: {
                    return SecurityUtils.getSubject().isPermittedAll(permissions.toArray(new String[permissions.size()]));
                }
                case OR: {
                    return ShiroTools.isPermitted(permissions.toArray(new String[permissions.size()]));
                }
            }
        }
        return false;
    }

    private boolean verify(Request request, JSON config) {
        if (config.get("require") != null) {
            return this.hasRequire(request, config);
        }
        if (config.get("roles") != null && config.get("permissions") != null) {
            return this.hasRoles(request, config) && this.hasPermissions(request, config);
        }
        if (config.get("permissions") != null && config.get("roles") == null) {
            return this.hasPermissions(request, config);
        }
        if (config.get("roles") != null && config.get("permissions") == null) {
            return this.hasRoles(request, config);
        }
        return true;
    }
}

