/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.inject.Provider;
import juzu.impl.common.JSON;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.request.Request;
import juzu.plugin.shiro.impl.JuzuRememberMe;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;

public class SecurityManagerProvider
implements Provider<SecurityManager> {
    private final JSON config;

    public SecurityManagerProvider(JSON config) {
        this.config = config;
    }

    public SecurityManager get() {
        boolean rememberMeSupported;
        SecurityManager manager = null;
        try {
            manager = SecurityUtils.getSecurityManager();
        }
        catch (UnavailableSecurityManagerException e1) {
            manager = new DefaultSecurityManager();
        }
        boolean bl = rememberMeSupported = this.config.get("rememberMe") != null;
        if (rememberMeSupported && manager instanceof DefaultSecurityManager) {
            ((DefaultSecurityManager)manager).setRememberMeManager((RememberMeManager)new JuzuRememberMe());
        }
        if (this.config.get("realms") != null) {
            try {
                this.injectRealms(this.config, manager, Request.getCurrent().getApplication().getInjectionContext());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return manager;
    }

    private void injectRealms(JSON config, SecurityManager currentManager, InjectionContext manager) throws InvocationTargetException {
        JSON realmsJSON = config.getJSON("realms");
        Iterable beans = manager.resolveBeans(AuthorizingRealm.class);
        for (Object bean : beans) {
            Collection realms;
            Object instance;
            AuthorizingRealm realm = (AuthorizingRealm)AuthorizingRealm.class.cast(manager.getInstance(bean, instance = manager.createContext(bean)));
            JSON realmJSON = realmsJSON.getJSON(realm.getClass().getName());
            if (realmJSON == null) continue;
            if (realmJSON.get("name") != null) {
                realm.setName(realmJSON.getString("name"));
            }
            if ((realms = ((RealmSecurityManager)currentManager).getRealms()) == null) {
                ((RealmSecurityManager)currentManager).setRealm((Realm)realm);
                continue;
            }
            ((RealmSecurityManager)currentManager).getRealms().add(realm);
        }
    }
}

