/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.EntityUnmarshaller;
import juzu.request.ClientContext;
import juzu.request.RequestParameter;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class FileUploadUnmarshaller
extends EntityUnmarshaller {
    public boolean accept(String mediaType) {
        return mediaType.startsWith("multipart/");
    }

    public void unmarshall(String mediaType, final ClientContext context, Iterable<Map.Entry<ContextualParameter, Object>> contextualArguments, Map<String, RequestParameter> parameterArguments) throws IOException {
        RequestContext ctx = new RequestContext(){

            public String getCharacterEncoding() {
                return context.getCharacterEncoding();
            }

            public String getContentType() {
                return context.getContentType();
            }

            public int getContentLength() {
                return context.getContentLenth();
            }

            public InputStream getInputStream() throws IOException {
                return context.getInputStream();
            }
        };
        FileUpload upload = new FileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            List list = upload.parseRequest(ctx);
            HashMap<String, FileItem> files = new HashMap<String, FileItem>();
            for (FileItem fileItem : list) {
                String name = fileItem.getFieldName();
                if (fileItem.isFormField()) {
                    RequestParameter parameterArg = parameterArguments.get(name);
                    if (parameterArg == null) {
                        parameterArguments.put(name, RequestParameter.create((String)name, (String)fileItem.getString()));
                        continue;
                    }
                    parameterArguments.put(name, parameterArg.append(new String[]{fileItem.getString()}));
                    continue;
                }
                files.put(name, fileItem);
            }
            for (Map.Entry entry : contextualArguments) {
                ContextualParameter contextualParam = (ContextualParameter)entry.getKey();
                FileItem file = (FileItem)files.get(contextualParam.getName());
                if (file == null || !FileItem.class.isAssignableFrom(contextualParam.getType())) continue;
                entry.setValue(file);
            }
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
    }
}

