/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.webjars.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.module.metamodel.ModuleMetaModelPlugin;
import juzu.plugin.webjars.WebJars;
import org.webjars.WebJarAssetLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJarsMetaModelPlugin
extends ModuleMetaModelPlugin {
    static final Logger log = BaseProcessor.getLogger(WebJarsMetaModelPlugin.class);
    private HashMap<Name, AnnotationState> annotations;

    public WebJarsMetaModelPlugin() {
        super("webjars");
    }

    public void init(ModuleMetaModel metaModel) {
        this.annotations = new HashMap();
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(WebJars.class);
    }

    public void processAnnotationAdded(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        Name pkg = key.getElement().getPackageName();
        this.annotations.put(pkg, added);
    }

    public void processAnnotationRemoved(ModuleMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        Name pkg = key.getElement().getPackageName();
        this.annotations.remove(pkg);
    }

    public void postActivate(ModuleMetaModel metaModel) {
        this.annotations = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePassivate(ModuleMetaModel metaModel) {
        HashMap<Name, AnnotationState> clone = this.annotations;
        this.annotations = null;
        for (Map.Entry<Name, AnnotationState> entry : clone.entrySet()) {
            AnnotationState annotation = entry.getValue();
            Name pkg = entry.getKey();
            ProcessingContext env = metaModel.processingContext;
            ElementHandle.Package pkgHandle = ElementHandle.Package.create((Name)pkg);
            List resources = (List)annotation.get((Object)"value");
            if (resources == null || resources.size() <= 0) continue;
            Name assetPkg = pkg.append(new String[]{"assets"});
            for (String resource : resources) {
                log.log((CharSequence)("Processing declared webjars " + resource));
                String resourcePath = new WebJarAssetLocator().getFullPath(resource);
                URL url = WebJarAssetLocator.class.getClassLoader().getResource(resourcePath);
                if (url != null) {
                    Path.Absolute to = assetPkg.resolve(resource).as("js");
                    try {
                        log.log((CharSequence)("Webjars " + resource + " write on disk as " + to));
                        FileObject fo = env.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, to, new Element[0]);
                        Writer writer = fo.openWriter();
                        try {
                            writer.write(Tools.read((URL)url));
                        }
                        finally {
                            Tools.safeClose((Closeable)writer);
                        }
                    }
                    catch (IOException e) {
                        log.log((CharSequence)("Resource " + to + " could not be written on disk"), (Throwable)e);
                    }
                    continue;
                }
                log.log((CharSequence)("Could not resolve WebJars asset " + resource + " with resource path " + resourcePath));
            }
        }
    }
}

