/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.common.Tools;
import juzu.io.Stream;
import juzu.io.Streamable;

public abstract class ViewStreamable
implements Streamable {
    public static final PropertyType<Asset> STYLESHEET_ASSET = new PropertyType<Asset>(){};
    public static final PropertyType<Asset> SCRIPT_ASSET = new PropertyType<Asset>(){};
    private final Response.Body content;

    public ViewStreamable(Response.Body content) {
        this.content = content;
    }

    public void send(final Stream stream) throws IOException {
        Stream our = new Stream(){

            public Stream append(ByteBuffer buffer) throws IOException {
                stream.append(buffer);
                return this;
            }

            public Stream append(CharBuffer buffer) throws IOException {
                stream.append(buffer);
                return this;
            }

            public Stream append(CharSequence csq) throws IOException {
                stream.append(csq);
                return this;
            }

            public Stream append(CharSequence csq, int start, int end) throws IOException {
                stream.append(csq, start, end);
                return this;
            }

            public Stream append(char c) throws IOException {
                stream.append(c);
                return this;
            }

            public Stream append(byte[] data) throws IOException {
                stream.append(data);
                return this;
            }

            public Stream append(byte[] data, int off, int len) throws IOException {
                stream.append(data, off, len);
                return this;
            }

            public void flush() throws IOException {
                stream.flush();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    if (ViewStreamable.this.content instanceof Response.Content) {
                        ViewStreamable.this.sendFooter(stream);
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    Tools.safeClose(stream);
                    throw throwable;
                }
                Tools.safeClose(stream);
            }
        };
        if (this.content instanceof Response.Content) {
            this.sendHeader(stream);
        }
        this.content.getStreamable().send(our);
    }

    private void sendHeader(Stream writer) throws IOException {
        Iterable<Asset> scripts;
        Iterable<Asset> stylesheets;
        Iterable<Map.Entry<String, String>> metaProps;
        PropertyMap properties = this.content.getProperties();
        writer.append("<!DOCTYPE html>\n");
        writer.append("<html>\n");
        writer.append("<head>\n");
        String title = properties.getValue(PropertyType.TITLE);
        if (title != null) {
            writer.append("<title>");
            writer.append(title);
            writer.append("</title>\n");
        }
        if ((metaProps = properties.getValues(PropertyType.META_TAG)) != null) {
            for (Map.Entry<String, String> meta : metaProps) {
                writer.append("<meta name=\"");
                writer.append(meta.getKey());
                writer.append("\" content=\"");
                writer.append(meta.getValue());
                writer.append("\">\n");
            }
        }
        if ((stylesheets = properties.getValues(STYLESHEET_ASSET)) != null) {
            for (Asset stylesheet : stylesheets) {
                String path = stylesheet.getURI();
                int pos = path.lastIndexOf(46);
                String ext = pos == -1 ? "css" : path.substring(pos + 1);
                writer.append("<link rel=\"stylesheet\" type=\"text/");
                writer.append(ext);
                writer.append("\" href=\"");
                this.renderAssetURL(stylesheet.getLocation(), stylesheet.getURI(), writer);
                writer.append("\"></link>\n");
            }
        }
        if ((scripts = properties.getValues(SCRIPT_ASSET)) != null) {
            for (Asset script : scripts) {
                writer.append("<script type=\"text/javascript\" src=\"");
                this.renderAssetURL(script.getLocation(), script.getURI(), writer);
                writer.append("\"></script>\n");
            }
        }
        writer.append("</head>\n");
        writer.append("<body>\n");
    }

    private void sendFooter(Stream writer) throws IOException {
        writer.append("</body>\n");
        writer.append("</html>\n");
    }

    public abstract void renderAssetURL(AssetLocation var1, String var2, Appendable var3) throws IOException;
}

