/*
 * Copyright (C) 2012 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package juzu.bridge.vertx;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.config.RedirectConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import junit.framework.AssertionFailedError;
import juzu.impl.common.Tools;
import org.junit.runner.RunWith;
import org.vertx.java.test.VertxConfiguration;
import org.vertx.java.test.VertxTestBase;
import org.vertx.java.test.junit.VertxJUnit4ClassRunner;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
@RunWith(VertxJUnit4ClassRunner.class)
@VertxConfiguration()
public abstract class VertxTestCase extends VertxTestBase {

  static {
    RestAssured.config = new RestAssuredConfig().redirect(new RedirectConfig().followRedirects(true));
  }

  protected String assertOK(URL url) {
    return assertStatus(200, url);
  }

  protected String assertStatus(int expectedStatus, URL url) {
    try {
      HttpURLConnection conn = (HttpURLConnection)url.openConnection();
      conn.connect();
      int responseCode = conn.getResponseCode();
      InputStream in;
      if (responseCode >= 200 && responseCode < 300) {
        in = conn.getInputStream();
      } else {
        in = conn.getErrorStream();
      }
      String content = Tools.read(in);
      if (responseCode != 200) {
        throw new AssertionFailedError("Was expecting 200 code instead of " +
            responseCode + " with content " + content);
      } else {
        return content;
      }
    }
    catch (IOException e) {
      AssertionFailedError afe = new AssertionFailedError();
      afe.initCause(e);
      throw afe;
    }
  }

}
